package com.liveperson.messaging.sdk.api.model

import com.liveperson.infra.log.LPLog.mask
import com.liveperson.infra.log.LPLog.v
import com.liveperson.messaging.model.UserProfile

/**
 * Model representing a Consumer's personal info, that an Agent may need to better
 * assist them.
 */
data class ConsumerProfile(
		val firstName: String?,
		val lastName: String?,
		val nickname: String?,
		val phoneNumber: String?,
		val avatarUrl: String?
) {

	init {
		v(TAG, "Built a ${mask(this)}")
	}

	fun toUserProfile(): UserProfile {
		return UserProfile(firstName, lastName, phoneNumber, nickname, avatarUrl)
	}

	@Suppress("unused") // Providing options for client developers.
	class Builder {
		private var firstName: String? = null
		private var lastName: String? = null
		private var nickname: String? = null
		private var phoneNumber: String? = null
		private var avatarUrl: String? = null

		fun firstName(firstName: String?) = apply { this.firstName = firstName }
		fun lastName(lastName: String?) = apply { this.lastName = lastName }
		fun nickname(nickname: String?) = apply { this.nickname = nickname }
		fun phoneNumber(phoneNumber: String?) = apply { this.phoneNumber = phoneNumber }
		fun avatarUrl(avatarUrl: String?) = apply { this.avatarUrl = avatarUrl }

		fun setFirstName(firstName: String?) = apply { this.firstName = firstName }
		fun setLastName(lastName: String?) = apply { this.lastName = lastName }
		fun setNickname(nickname: String?) = apply { this.nickname = nickname }
		fun setPhoneNumber(phoneNumber: String?) = apply { this.phoneNumber = phoneNumber }
		fun setAvatarUrl(avatarUrl: String?) = apply { this.avatarUrl = avatarUrl }

		fun build(): ConsumerProfile {
			return ConsumerProfile(firstName, lastName, nickname, phoneNumber, avatarUrl)
		}
	}

	companion object {
		private const val TAG = "ConsumerProfile"
	}
}
