/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.javax.annotation.Nonnull;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Pair<T1, T2>
implements Comparable<Pair<T1, T2>>,
Map.Entry<T1, T2>,
Serializable {
    public final T1 left;
    public final T2 right;

    public Pair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 left, T2 right) {
        return new Pair<T1, T2>(left, right);
    }

    public static <K, V> Pair<K, V> of(Map.Entry<K, V> entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pair && Objects.equals(this.left, ((Pair)obj).left) && Objects.equals(this.right, ((Pair)obj).right);
    }

    @Override
    public int hashCode() {
        int keyHash = this.left == null ? 0 : this.left.hashCode();
        int valueHash = this.right == null ? 0 : this.right.hashCode();
        return keyHash ^ valueHash;
    }

    @Override
    public int compareTo(@Nonnull Pair<T1, T2> that) {
        int c = Pair.compare((Comparable)this.left, (Comparable)that.left);
        if (c == 0) {
            c = Pair.compare((Comparable)this.right, (Comparable)that.right);
        }
        return c;
    }

    public String toString() {
        return "<" + this.left + ", " + this.right + ">";
    }

    @Override
    public T1 getKey() {
        return this.left;
    }

    @Override
    public T2 getValue() {
        return this.right;
    }

    @Override
    public T2 setValue(T2 value) {
        throw new UnsupportedOperationException();
    }

    private static <C extends Comparable<C>> int compare(C c1, C c2) {
        if (c1 == null) {
            if (c2 == null) {
                return 0;
            }
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static <K, V> Map<K, V> toMap(Iterable<Pair<K, V>> pairs) {
        HashMap map = new HashMap();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.left, pair.right);
        }
        return map;
    }

    public static <K, V> List<Pair<K, V>> zip(List<K> ks, List<V> vs) {
        return Pair.zip(ks, vs, false);
    }

    public static <K, V> List<Pair<K, V>> zip(List<K> ks, List<V> vs, boolean strict) {
        int size;
        if (strict) {
            if (ks.size() != vs.size()) {
                throw new AssertionError();
            }
            size = ks.size();
        } else {
            size = Math.min(ks.size(), vs.size());
        }
        return new ZipList<K, V>(ks, vs, size);
    }

    public static <K, V> Iterable<Pair<K, V>> zip(Iterable<? extends K> ks, Iterable<? extends V> vs) {
        return () -> {
            Iterator kIterator = ks.iterator();
            Iterator vIterator = vs.iterator();
            return new ZipIterator(kIterator, vIterator);
        };
    }

    public static <K, V> List<Pair<K, V>> zip(final K[] ks, final V[] vs) {
        return new AbstractList<Pair<K, V>>(){

            @Override
            public Pair<K, V> get(int index) {
                return Pair.of(ks[index], vs[index]);
            }

            @Override
            public int size() {
                return Math.min(ks.length, vs.length);
            }
        };
    }

    public static <K, V> List<Pair<K, V>> zipMutable(List<K> ks, List<V> vs) {
        return new MutableZipList<K, V>(ks, vs);
    }

    public static <L, R> Iterable<L> left(Iterable<? extends Map.Entry<L, R>> iterable) {
        return () -> new LeftIterator(iterable.iterator());
    }

    public static <L, R> Iterable<R> right(Iterable<? extends Map.Entry<L, R>> iterable) {
        return () -> new RightIterator(iterable.iterator());
    }

    public static <K, V> List<K> left(final List<? extends Map.Entry<K, V>> pairs) {
        return new AbstractList<K>(){

            @Override
            public K get(int index) {
                return ((Map.Entry)pairs.get(index)).getKey();
            }

            @Override
            public int size() {
                return pairs.size();
            }
        };
    }

    public static <K, V> List<V> right(final List<? extends Map.Entry<K, V>> pairs) {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)pairs.get(index)).getValue();
            }

            @Override
            public int size() {
                return pairs.size();
            }
        };
    }

    public static <T> Iterable<Pair<T, T>> adjacents(Iterable<T> iterable) {
        return () -> {
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                return Collections.emptyIterator();
            }
            return new AdjacentIterator(iterator);
        };
    }

    public static <T> Iterable<Pair<T, T>> firstAnd(Iterable<T> iterable) {
        return () -> {
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                return Collections.emptyIterator();
            }
            Object first = iterator.next();
            return new FirstAndIterator(iterator, first);
        };
    }

    private static class ZipList<K, V>
    extends AbstractList<Pair<K, V>> {
        private final List<K> ks;
        private final List<V> vs;
        private final int size;

        ZipList(List<K> ks, List<V> vs, int size) {
            this.ks = ks;
            this.vs = vs;
            this.size = size;
        }

        @Override
        public Pair<K, V> get(int index) {
            return Pair.of(this.ks.get(index), this.vs.get(index));
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class MutableZipList<K, V>
    extends AbstractList<Pair<K, V>> {
        private final List<K> ks;
        private final List<V> vs;

        MutableZipList(List<K> ks, List<V> vs) {
            this.ks = Objects.requireNonNull(ks);
            this.vs = Objects.requireNonNull(vs);
        }

        @Override
        public Pair<K, V> get(int index) {
            return Pair.of(this.ks.get(index), this.vs.get(index));
        }

        @Override
        public int size() {
            return Math.min(this.ks.size(), this.vs.size());
        }

        @Override
        public void add(int index, Pair<K, V> pair) {
            this.ks.add(index, pair.left);
            this.vs.add(index, pair.right);
        }

        @Override
        public Pair<K, V> remove(int index) {
            K bufferedRow = this.ks.remove(index);
            V stateSet = this.vs.remove(index);
            return Pair.of(bufferedRow, stateSet);
        }

        @Override
        public Pair<K, V> set(int index, Pair<K, V> pair) {
            Object previous = this.get(index);
            this.ks.set(index, pair.left);
            this.vs.set(index, pair.right);
            return previous;
        }
    }

    private static class FirstAndIterator<E>
    implements Iterator<Pair<E, E>> {
        private final Iterator<E> iterator;
        private final E first;

        FirstAndIterator(Iterator<E> iterator, E first) {
            this.iterator = Objects.requireNonNull(iterator);
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<E, E> next() {
            return Pair.of(this.first, this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class AdjacentIterator<E>
    implements Iterator<Pair<E, E>> {
        private final E first;
        private final Iterator<E> iterator;
        E previous;

        AdjacentIterator(Iterator<E> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.first = iterator.next();
            this.previous = this.first;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<E, E> next() {
            E current = this.iterator.next();
            Pair<E, E> pair = Pair.of(this.previous, current);
            this.previous = current;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class RightIterator<L, R>
    implements Iterator<R> {
        private final Iterator<? extends Map.Entry<L, R>> iterator;

        RightIterator(Iterator<? extends Map.Entry<L, R>> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public R next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class LeftIterator<L, R>
    implements Iterator<L> {
        private final Iterator<? extends Map.Entry<L, R>> iterator;

        LeftIterator(Iterator<? extends Map.Entry<L, R>> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public L next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class ZipIterator<L, R>
    implements Iterator<Pair<L, R>> {
        private final Iterator<? extends L> leftIterator;
        private final Iterator<? extends R> rightIterator;

        ZipIterator(Iterator<? extends L> leftIterator, Iterator<? extends R> rightIterator) {
            this.leftIterator = Objects.requireNonNull(leftIterator);
            this.rightIterator = Objects.requireNonNull(rightIterator);
        }

        @Override
        public boolean hasNext() {
            return this.leftIterator.hasNext() && this.rightIterator.hasNext();
        }

        @Override
        public Pair<L, R> next() {
            return Pair.of(this.leftIterator.next(), this.rightIterator.next());
        }

        @Override
        public void remove() {
            this.leftIterator.remove();
            this.rightIterator.remove();
        }
    }
}

