/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.calcite.util.CaseInsensitiveComparator;
import org.apache.calcite.util.NameMap;

public class NameSet {
    public static final Comparator<String> COMPARATOR = CaseInsensitiveComparator.COMPARATOR;
    private static final Object DUMMY = new Object();
    private final NameMap<Object> names;

    private NameSet(NameMap<Object> names) {
        this.names = names;
    }

    public NameSet() {
        this(new NameMap<Object>());
    }

    public static NameSet immutableCopyOf(Set<String> names) {
        return new NameSet(NameMap.immutableCopyOf(Maps.asMap(names, k -> DUMMY)));
    }

    public String toString() {
        return this.names.map().keySet().toString();
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NameSet && this.names.equals(((NameSet)obj).names);
    }

    public void add(String name) {
        this.names.put(name, DUMMY);
    }

    public Collection<String> range(String name, boolean caseSensitive) {
        return this.names.range(name, caseSensitive).keySet();
    }

    public boolean contains(String name, boolean caseSensitive) {
        return this.names.containsKey(name, caseSensitive);
    }

    public Iterable<String> iterable() {
        return Collections.unmodifiableSet(this.names.map().keySet());
    }
}

