/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.linkedin.coral.com.google.common.collect.ImmutableCollection;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.runtime.Automaton;

public class DeterministicAutomaton {
    final MultiState startState;
    private final Automaton automaton;
    private final ImmutableSet<MultiState> endStates;
    private final ImmutableList<Transition> transitions;

    DeterministicAutomaton(Automaton automaton) {
        this.automaton = Objects.requireNonNull(automaton);
        HashSet<MultiState> traversedStates = new HashSet<MultiState>();
        this.startState = this.epsilonClosure(automaton.startState);
        ImmutableList.Builder<Transition> transitionsBuilder = ImmutableList.builder();
        this.traverse(this.startState, transitionsBuilder, traversedStates);
        this.transitions = transitionsBuilder.build();
        ImmutableSet.Builder endStateBuilder = ImmutableSet.builder();
        traversedStates.stream().filter(ms -> ms.contains(automaton.endState)).forEach(endStateBuilder::add);
        this.endStates = endStateBuilder.build();
    }

    MultiState getStartState() {
        return this.startState;
    }

    public ImmutableSet<MultiState> getEndStates() {
        return this.endStates;
    }

    public ImmutableList<Transition> getTransitions() {
        return this.transitions;
    }

    private void traverse(MultiState start, ImmutableList.Builder<Transition> transitionsBuilder, Set<MultiState> traversedStates) {
        traversedStates.add(start);
        HashSet newStates = new HashSet();
        for (int symbol = 0; symbol < this.automaton.symbolNames.size(); ++symbol) {
            Optional<MultiState> next = this.addTransitions(start, symbol, transitionsBuilder);
            next.ifPresent(newStates::add);
        }
        newStates.removeAll(traversedStates);
        newStates.forEach(s -> this.traverse((MultiState)s, transitionsBuilder, traversedStates));
    }

    private Optional<MultiState> addTransitions(MultiState start, int symbol, ImmutableList.Builder<Transition> transitionsBuilder) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Automaton.SymbolTransition transition : this.automaton.getTransitions()) {
            if (transition.symbol != symbol || !start.contains(transition.fromState)) continue;
            builder.addAll((Iterable)this.epsilonClosure(transition.toState).states);
        }
        ImmutableCollection stateSet = builder.build();
        if (stateSet.isEmpty()) {
            return Optional.empty();
        }
        MultiState next = new MultiState((ImmutableSet<Automaton.State>)builder.build());
        Transition transition = new Transition(start, next, symbol, (String)this.automaton.symbolNames.get(symbol));
        transitionsBuilder.add((Object)transition);
        return Optional.of(next);
    }

    private MultiState epsilonClosure(Automaton.State state) {
        HashSet<Automaton.State> closure = new HashSet<Automaton.State>();
        this.finder(state, closure);
        return new MultiState(ImmutableSet.copyOf(closure));
    }

    private void finder(Automaton.State state, Set<Automaton.State> closure) {
        closure.add(state);
        Set newStates = this.automaton.getEpsilonTransitions().stream().filter(t -> t.fromState.equals(state)).map(t -> t.toState).collect(Collectors.toSet());
        newStates.removeAll(closure);
        for (Automaton.State s : newStates) {
            this.finder(s, closure);
        }
    }

    static class MultiState {
        private final ImmutableSet<Automaton.State> states;

        MultiState(Automaton.State ... states) {
            this(ImmutableSet.copyOf(states));
        }

        MultiState(ImmutableSet<Automaton.State> states) {
            this.states = Objects.requireNonNull(states);
        }

        public boolean contains(Automaton.State state) {
            return this.states.contains(state);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof MultiState && Objects.equals(this.states, ((MultiState)o).states);
        }

        public int hashCode() {
            return Objects.hash(this.states);
        }

        public String toString() {
            return this.states.toString();
        }
    }

    static class Transition {
        final MultiState fromState;
        final MultiState toState;
        final int symbolId;
        final String symbol;

        Transition(MultiState fromState, MultiState toState, int symbolId, String symbol) {
            this.fromState = Objects.requireNonNull(fromState);
            this.toState = Objects.requireNonNull(toState);
            this.symbolId = symbolId;
            this.symbol = Objects.requireNonNull(symbol);
        }
    }
}

