/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;

public abstract class SemiJoinRule
extends RelOptRule {
    private static final Predicate<Join> NOT_GENERATE_NULLS_ON_LEFT = join -> !join.getJoinType().generatesNullsOnLeft();
    private static final Predicate<Aggregate> IS_EMPTY_AGGREGATE = aggregate -> aggregate.getRowType().getFieldCount() == 0;
    public static final SemiJoinRule PROJECT = new ProjectToSemiJoinRule(Project.class, Join.class, Aggregate.class, RelFactories.LOGICAL_BUILDER, "SemiJoinRule:project");
    public static final SemiJoinRule JOIN = new JoinToSemiJoinRule(Join.class, Aggregate.class, RelFactories.LOGICAL_BUILDER, "SemiJoinRule:join");

    protected SemiJoinRule(Class<Project> projectClass, Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
        super(SemiJoinRule.operand(projectClass, SemiJoinRule.some(SemiJoinRule.operandJ(joinClass, null, NOT_GENERATE_NULLS_ON_LEFT, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(aggregateClass, SemiJoinRule.any()))), new RelOptRuleOperand[0])), relBuilderFactory, description);
    }

    protected SemiJoinRule(Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
        super(SemiJoinRule.operandJ(joinClass, null, NOT_GENERATE_NULLS_ON_LEFT, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(aggregateClass, SemiJoinRule.any()))), relBuilderFactory, description);
    }

    protected void perform(RelOptRuleCall call, Project project, Join join, RelNode left, Aggregate aggregate) {
        ImmutableBitSet rightBits;
        ImmutableBitSet bits;
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (project != null ? (bits = RelOptUtil.InputFinder.bits(project.getProjects(), null)).intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount())) : join.getJoinType().projectsRight() && !IS_EMPTY_AGGREGATE.test(aggregate)) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(left);
        switch (join.getJoinType()) {
            case SEMI: 
            case INNER: {
                ArrayList<Integer> newRightKeyBuilder = new ArrayList<Integer>();
                List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
                for (int key : joinInfo.rightKeys) {
                    newRightKeyBuilder.add(aggregateKeys.get(key));
                }
                ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
                relBuilder.push(aggregate.getInput());
                RexNode newCondition = RelOptUtil.createEquiJoinCondition(relBuilder.peek(2, 0), joinInfo.leftKeys, relBuilder.peek(2, 1), newRightKeys, rexBuilder);
                relBuilder.semiJoin(newCondition);
                break;
            }
            case LEFT: {
                break;
            }
            default: {
                throw new AssertionError((Object)join.getJoinType());
            }
        }
        if (project != null) {
            relBuilder.project(project.getProjects(), project.getRowType().getFieldNames());
        }
        RelNode relNode = relBuilder.build();
        call.transformTo(relNode);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        Object left = call.rel(1);
        Aggregate aggregate = (Aggregate)call.rel(2);
        this.perform(call, null, join, (RelNode)left, aggregate);
    }

    public static class ProjectToSemiJoinRule
    extends SemiJoinRule {
        public ProjectToSemiJoinRule(Class<Project> projectClass, Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            super(projectClass, joinClass, aggregateClass, relBuilderFactory, description);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            Object left = call.rel(2);
            Aggregate aggregate = (Aggregate)call.rel(3);
            this.perform(call, project, join, (RelNode)left, aggregate);
        }
    }

    public static class JoinToSemiJoinRule
    extends SemiJoinRule {
        public JoinToSemiJoinRule(Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            super(joinClass, aggregateClass, relBuilderFactory, description);
        }
    }
}

