/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilderFactory;

public class ProjectJoinTransposeRule
extends RelOptRule {
    public static final ProjectJoinTransposeRule INSTANCE = new ProjectJoinTransposeRule(expr -> !(expr instanceof RexOver), RelFactories.LOGICAL_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectJoinTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(ProjectJoinTransposeRule.operand(Project.class, ProjectJoinTransposeRule.operand(Join.class, ProjectJoinTransposeRule.any()), new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(final RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (!join.getJoinType().projectsRight()) {
            return;
        }
        RexNode joinFilter = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall rexCall) {
                RexNode node = super.visitCall(rexCall);
                if (!(node instanceof RexCall)) {
                    return node;
                }
                return RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)node, call.builder().getRexBuilder());
            }
        });
        PushProjector pushProject = new PushProjector(origProj, joinFilter, join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (joinFilter != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(joinFilter, projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

