/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.Ordering;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.materialize.LatticeTable;
import org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.util.graph.AttributedDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.mapping.IntPair;

class Step
extends DefaultEdge {
    final List<IntPair> keys;

    Step(LatticeTable source, LatticeTable target, List<IntPair> keys) {
        super(source, target);
        this.keys = ImmutableList.copyOf(keys);
        assert (IntPair.ORDERING.isStrictlyOrdered(keys));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.keys);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Step && ((Step)obj).source.equals(this.source) && ((Step)obj).target.equals(this.target) && ((Step)obj).keys.equals(this.keys);
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append("Step(").append(this.source).append(", ").append(this.target).append(",");
        for (IntPair key : this.keys) {
            b.append(' ').append(this.source().field(key.source).getName()).append(':').append(this.target().field(key.target).getName());
        }
        return b.append(")").toString();
    }

    LatticeTable source() {
        return (LatticeTable)this.source;
    }

    LatticeTable target() {
        return (LatticeTable)this.target;
    }

    boolean isBackwards(SqlStatisticProvider statisticProvider) {
        boolean backwardForeignKey;
        List<Integer> targetColumns;
        RelOptTable targetTable;
        RelOptTable sourceTable = this.source().t;
        List<Integer> sourceColumns = IntPair.left(this.keys);
        boolean forwardForeignKey = statisticProvider.isForeignKey(sourceTable, sourceColumns, targetTable = this.target().t, targetColumns = IntPair.right(this.keys)) && statisticProvider.isKey(targetTable, targetColumns);
        boolean bl = backwardForeignKey = statisticProvider.isForeignKey(targetTable, targetColumns, sourceTable, sourceColumns) && statisticProvider.isKey(sourceTable, sourceColumns);
        if (backwardForeignKey != forwardForeignKey) {
            return backwardForeignKey;
        }
        return Step.compare(sourceTable, sourceColumns, targetTable, targetColumns) < 0;
    }

    private static int compare(RelOptTable table1, List<Integer> columns1, RelOptTable table2, List<Integer> columns2) {
        int c = Ordering.natural().lexicographical().compare(table1.getQualifiedName(), table2.getQualifiedName());
        if (c == 0) {
            c = Ordering.natural().lexicographical().compare(columns1, columns2);
        }
        return c;
    }

    private double cardinality(SqlStatisticProvider statisticProvider, LatticeTable table) {
        return statisticProvider.tableCardinality(table.t);
    }

    static class Factory
    implements AttributedDirectedGraph.AttributedEdgeFactory<LatticeTable, Step> {
        Factory() {
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target, Object ... attributes) {
            List keys = (List)attributes[0];
            return new Step(source, target, keys);
        }
    }
}

