/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.linkedin.coral.com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableCollection;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableListMultimap;
import com.linkedin.coral.com.google.common.collect.ImmutableSortedSet;
import com.linkedin.coral.com.google.common.collect.LinkedHashMultimap;
import com.linkedin.coral.com.google.common.collect.Lists;
import com.linkedin.coral.com.google.common.collect.Multimap;
import com.linkedin.coral.com.google.common.collect.Ordering;
import com.linkedin.coral.javax.annotation.Nonnull;
import com.linkedin.coral.javax.annotation.Nullable;
import com.linkedin.coral.javax.annotation.ParametersAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.materialize.LatticeChildNode;
import org.apache.calcite.materialize.LatticeNode;
import org.apache.calcite.materialize.LatticeRootNode;
import org.apache.calcite.materialize.LatticeSpace;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.materialize.LatticeTable;
import org.apache.calcite.materialize.Lattices;
import org.apache.calcite.materialize.MutableNode;
import org.apache.calcite.materialize.Path;
import org.apache.calcite.materialize.Step;
import org.apache.calcite.materialize.TileSuggester;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.statistic.MapSqlStatisticProvider;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.calcite.util.mapping.IntPair;

@ParametersAreNonnullByDefault
public class Lattice {
    public final CalciteSchema rootSchema;
    public final LatticeRootNode rootNode;
    public final ImmutableList<Column> columns;
    public final boolean auto;
    public final boolean algorithm;
    public final long algorithmMaxMillis;
    public final double rowCountEstimate;
    public final ImmutableList<Measure> defaultMeasures;
    public final ImmutableList<Tile> tiles;
    public final ImmutableListMultimap<Integer, Boolean> columnUses;
    public final LatticeStatisticProvider statisticProvider;

    private Lattice(CalciteSchema rootSchema, LatticeRootNode rootNode, boolean auto, boolean algorithm, long algorithmMaxMillis, LatticeStatisticProvider.Factory statisticProviderFactory, @Nullable Double rowCountEstimate, ImmutableList<Column> columns, ImmutableSortedSet<Measure> defaultMeasures, ImmutableList<Tile> tiles, ImmutableListMultimap<Integer, Boolean> columnUses) {
        this.rootSchema = rootSchema;
        this.rootNode = Objects.requireNonNull(rootNode);
        this.columns = Objects.requireNonNull(columns);
        this.auto = auto;
        this.algorithm = algorithm;
        this.algorithmMaxMillis = algorithmMaxMillis;
        this.defaultMeasures = defaultMeasures.asList();
        this.tiles = Objects.requireNonNull(tiles);
        this.columnUses = columnUses;
        assert (this.isValid(Litmus.THROW));
        if (rowCountEstimate == null) {
            rowCountEstimate = 1000.0;
        }
        Preconditions.checkArgument(rowCountEstimate > 0.0);
        this.rowCountEstimate = rowCountEstimate;
        this.statisticProvider = Objects.requireNonNull((LatticeStatisticProvider)statisticProviderFactory.apply(this));
    }

    public static Lattice create(CalciteSchema schema, String sql, boolean auto) {
        return Lattice.builder(schema, sql).auto(auto).build();
    }

    private boolean isValid(Litmus litmus) {
        if (!this.rootNode.isValid(litmus)) {
            return false;
        }
        for (Measure measure : this.defaultMeasures) {
            for (Column arg : measure.args) {
                if (this.columns.get(arg.ordinal) == arg) continue;
                return litmus.fail("measure argument must be a column registered in this lattice: {}", measure);
            }
        }
        return litmus.succeed();
    }

    private static void populateAliases(SqlNode from, List<String> aliases, @Nullable String current) {
        if (from instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)from;
            Lattice.populateAliases(join.getLeft(), aliases, null);
            Lattice.populateAliases(join.getRight(), aliases, null);
        } else if (from.getKind() == SqlKind.AS) {
            Lattice.populateAliases(SqlUtil.stripAs(from), aliases, SqlValidatorUtil.getAlias(from, -1));
        } else {
            if (current == null) {
                current = SqlValidatorUtil.getAlias(from, -1);
            }
            aliases.add(current);
        }
    }

    private static boolean populate(List<RelNode> nodes, List<int[][]> tempLinks, RelNode rel) {
        if (nodes.isEmpty() && rel instanceof LogicalProject) {
            return Lattice.populate(nodes, tempLinks, ((LogicalProject)rel).getInput());
        }
        if (rel instanceof TableScan) {
            nodes.add(rel);
            return true;
        }
        if (rel instanceof LogicalJoin) {
            LogicalJoin join = (LogicalJoin)rel;
            if (join.getJoinType().isOuterJoin()) {
                throw new RuntimeException("only non nulls-generating join allowed, but got " + (Object)((Object)join.getJoinType()));
            }
            Lattice.populate(nodes, tempLinks, join.getLeft());
            Lattice.populate(nodes, tempLinks, join.getRight());
            for (RexNode rex : RelOptUtil.conjunctions(join.getCondition())) {
                tempLinks.add(Lattice.grab(nodes, rex));
            }
            return true;
        }
        throw new RuntimeException("Invalid node type " + rel.getClass().getSimpleName() + " in lattice query");
    }

    private static int[][] grab(List<RelNode> leaves, RexNode rex) {
        switch (rex.getKind()) {
            case EQUALS: {
                break;
            }
            default: {
                throw new AssertionError((Object)"only equi-join allowed");
            }
        }
        List<RexNode> operands = ((RexCall)rex).getOperands();
        return new int[][]{Lattice.inputField(leaves, operands.get(0)), Lattice.inputField(leaves, operands.get(1))};
    }

    private static int[] inputField(List<RelNode> leaves, RexNode rex) {
        if (!(rex instanceof RexInputRef)) {
            throw new RuntimeException("only equi-join of columns allowed: " + rex);
        }
        RexInputRef ref = (RexInputRef)rex;
        int start = 0;
        for (int i = 0; i < leaves.size(); ++i) {
            RelNode leaf = leaves.get(i);
            int end = start + leaf.getRowType().getFieldCount();
            if (ref.getIndex() < end) {
                return new int[]{i, ref.getIndex() - start};
            }
            start = end;
        }
        throw new AssertionError((Object)"input not found");
    }

    public String toString() {
        return this.rootNode + ":" + this.defaultMeasures;
    }

    public String sql(ImmutableBitSet groupSet, List<Measure> aggCallList) {
        return this.sql(groupSet, true, aggCallList);
    }

    public String sql(ImmutableBitSet groupSet, boolean group, List<Measure> aggCallList) {
        ArrayList<LatticeNode> usedNodes = new ArrayList<LatticeNode>();
        if (group) {
            ImmutableBitSet.Builder columnSetBuilder = groupSet.rebuild();
            for (Measure measure : aggCallList) {
                for (Column arg : measure.args) {
                    columnSetBuilder.set(arg.ordinal);
                }
            }
            ImmutableBitSet columnSet = columnSetBuilder.build();
            for (LatticeNode node : this.rootNode.descendants) {
                if (ImmutableBitSet.range(node.startCol, node.endCol).intersects(columnSet)) {
                    node.use(usedNodes);
                }
                if (!usedNodes.isEmpty()) continue;
                usedNodes.add(this.rootNode);
            }
        } else {
            usedNodes.addAll(this.rootNode.descendants);
        }
        SqlDialect dialect = SqlDialect.DatabaseProduct.CALCITE.getDialect();
        StringBuilder buf = new StringBuilder("SELECT ");
        StringBuilder stringBuilder = new StringBuilder("\nGROUP BY ");
        int k = 0;
        HashSet<String> columnNames = new HashSet<String>();
        SqlWriter w = this.createSqlWriter(dialect, buf, f -> {
            throw new UnsupportedOperationException();
        });
        if (groupSet != null) {
            for (int i : groupSet) {
                if (k++ > 0) {
                    buf.append(", ");
                    stringBuilder.append(", ");
                }
                Column column = (Column)this.columns.get(i);
                column.toSql(w);
                column.toSql(w.with(stringBuilder));
                if (column instanceof BaseColumn) {
                    columnNames.add(((BaseColumn)column).column);
                }
                if (column.alias.equals(column.defaultAlias())) continue;
                buf.append(" AS ");
                dialect.quoteIdentifier(buf, column.alias);
            }
            int m = 0;
            for (Measure measure : aggCallList) {
                String measureName;
                if (k++ > 0) {
                    buf.append(", ");
                }
                buf.append(measure.agg.getName()).append("(");
                if (measure.args.isEmpty()) {
                    buf.append("*");
                } else {
                    int z = 0;
                    for (Column arg : measure.args) {
                        if (z++ > 0) {
                            buf.append(", ");
                        }
                        arg.toSql(w);
                    }
                }
                buf.append(") AS ");
                while (!columnNames.add(measureName = "m" + m)) {
                    ++m;
                }
                dialect.quoteIdentifier(buf, measureName);
            }
        } else {
            buf.append("*");
        }
        buf.append("\nFROM ");
        for (LatticeNode node : usedNodes) {
            if (node instanceof LatticeChildNode) {
                buf.append("\nJOIN ");
            }
            dialect.quoteIdentifier(buf, node.table.t.getQualifiedName());
            buf.append(" AS ");
            dialect.quoteIdentifier(buf, node.alias);
            if (!(node instanceof LatticeChildNode)) continue;
            LatticeChildNode node1 = (LatticeChildNode)node;
            buf.append(" ON ");
            k = 0;
            for (IntPair pair : node1.link) {
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                Column left = (Column)this.columns.get(node1.parent.startCol + pair.source);
                left.toSql(w);
                buf.append(" = ");
                Column right = (Column)this.columns.get(node.startCol + pair.target);
                right.toSql(w);
            }
        }
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println("Lattice SQL:\n" + buf);
        }
        if (group) {
            if (groupSet.isEmpty()) {
                stringBuilder.append("()");
            }
            buf.append((CharSequence)stringBuilder);
        }
        return buf.toString();
    }

    public SqlWriter createSqlWriter(SqlDialect dialect, StringBuilder buf, IntFunction<SqlNode> field) {
        return new SqlWriter(this, dialect, buf, new SqlImplementor.SimpleContext(dialect, field));
    }

    public String countSql(ImmutableBitSet groupSet) {
        return "select count(*) as c from (" + this.sql(groupSet, ImmutableList.of()) + ")";
    }

    public StarTable createStarTable() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (LatticeNode node : this.rootNode.descendants) {
            tables.add(node.table.t.unwrap(Table.class));
        }
        return StarTable.of(this, tables);
    }

    public static Builder builder(CalciteSchema calciteSchema, String sql) {
        return Lattice.builder(new LatticeSpace(MapSqlStatisticProvider.INSTANCE), calciteSchema, sql);
    }

    static Builder builder(LatticeSpace space, CalciteSchema calciteSchema, String sql) {
        return new Builder(space, calciteSchema, sql);
    }

    public List<Measure> toMeasures(List<AggregateCall> aggCallList) {
        return Lists.transform(aggCallList, this::toMeasure);
    }

    private Measure toMeasure(AggregateCall aggCall) {
        return new Measure(aggCall.getAggregation(), aggCall.isDistinct(), aggCall.name, Lists.transform(aggCall.getArgList(), this.columns::get));
    }

    public Iterable<? extends Tile> computeTiles() {
        if (!this.algorithm) {
            return this.tiles;
        }
        return new TileSuggester(this).tiles();
    }

    public double getFactRowCount() {
        return this.rowCountEstimate;
    }

    public double getRowCount(List<Column> columns) {
        return this.statisticProvider.cardinality(columns);
    }

    public static double getRowCount(double factCount, double ... columnCounts) {
        return Lattice.getRowCount(factCount, Primitive.asList(columnCounts));
    }

    public static double getRowCount(double factCount, List<Double> columnCounts) {
        double n = 1.0;
        for (Double columnCount : columnCounts) {
            if (!(columnCount > 1.0)) continue;
            n *= columnCount.doubleValue();
        }
        double a = (n - 1.0) / n;
        if (a == 1.0) {
            return factCount;
        }
        double v = n * (1.0 - Math.pow(a, factCount));
        return Math.min(v, factCount);
    }

    public List<String> uniqueColumnNames() {
        return Lists.transform(this.columns, column -> column.alias);
    }

    Pair<Path, Integer> columnToPathOffset(BaseColumn c) {
        for (Pair<LatticeNode, Path> p : Pair.zip(this.rootNode.descendants, this.rootNode.paths)) {
            if (!((LatticeNode)p.left).alias.equals(c.table)) continue;
            return Pair.of((Path)p.right, c.ordinal - ((LatticeNode)p.left).startCol);
        }
        throw new AssertionError((Object)("lattice column not found: " + c));
    }

    public Set<LatticeTable> tables() {
        return this.rootNode.descendants.stream().map(n -> n.table).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public int firstColumn(String tableAlias) {
        for (Column column : this.columns) {
            if (!(column instanceof BaseColumn) || !((BaseColumn)column).table.equals(tableAlias)) continue;
            return column.ordinal;
        }
        return -1;
    }

    public boolean isAlwaysMeasure(Column column) {
        return !((ImmutableList)this.columnUses.get((Object)column.ordinal)).contains(false);
    }

    public static class Builder {
        private final LatticeRootNode rootNode;
        private final ImmutableList<BaseColumn> baseColumns;
        private final ImmutableListMultimap<String, Column> columnsByAlias;
        private final SortedSet<Measure> defaultMeasureSet = new TreeSet<Measure>();
        private final ImmutableList.Builder<Tile> tileListBuilder = ImmutableList.builder();
        private final Multimap<Integer, Boolean> columnUses = LinkedHashMultimap.create();
        private final CalciteSchema rootSchema;
        private boolean algorithm = false;
        private long algorithmMaxMillis = -1L;
        private boolean auto = true;
        private Double rowCountEstimate;
        private String statisticProvider;
        private Map<String, DerivedColumn> derivedColumnsByName = new LinkedHashMap<String, DerivedColumn>();

        public Builder(LatticeSpace space, CalciteSchema schema, String sql) {
            this.rootSchema = Objects.requireNonNull(schema.root());
            Preconditions.checkArgument(this.rootSchema.isRoot(), "must be root schema");
            CalcitePrepare.ConvertResult parsed = Schemas.convert(MaterializedViewTable.MATERIALIZATION_CONNECTION, schema, schema.path(null), sql);
            ArrayList relNodes = new ArrayList();
            ArrayList tempLinks = new ArrayList();
            Lattice.populate(relNodes, tempLinks, parsed.root.rel);
            ArrayList aliases = new ArrayList();
            Lattice.populateAliases(((SqlSelect)parsed.sqlNode).getFrom(), aliases, null);
            DefaultDirectedGraph<Vertex, Edge> graph = DefaultDirectedGraph.create(Edge.FACTORY);
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            for (Pair p : Pair.zip(relNodes, aliases)) {
                LatticeTable table = space.register(((RelNode)p.left).getTable());
                Vertex vertex = new Vertex(table, (String)p.right);
                graph.addVertex(vertex);
                vertices.add(vertex);
            }
            for (int[][] tempLink : tempLinks) {
                Vertex target;
                Vertex source = (Vertex)vertices.get(tempLink[0][0]);
                Edge edge = (Edge)graph.getEdge(source, target = (Vertex)vertices.get(tempLink[1][0]));
                if (edge == null) {
                    edge = (Edge)graph.addEdge(source, target);
                }
                edge.pairs.add(IntPair.of(tempLink[0][1], tempLink[1][1]));
            }
            MutableNode root = null;
            IdentityHashMap<LatticeTable, MutableNode> map = new IdentityHashMap<LatticeTable, MutableNode>();
            for (Vertex vertex : TopologicalOrderIterator.of(graph)) {
                MutableNode node;
                List edges = graph.getInwardEdges(vertex);
                if (root == null) {
                    if (!edges.isEmpty()) {
                        throw new RuntimeException("root node must not have relationships: " + vertex);
                    }
                    root = node = new MutableNode(vertex.table);
                    node.alias = vertex.alias;
                } else {
                    if (edges.size() != 1) {
                        throw new RuntimeException("child node must have precisely one parent: " + vertex);
                    }
                    Edge edge = (Edge)edges.get(0);
                    MutableNode parent = (MutableNode)map.get(edge.getSource().table);
                    Step step = new Step(edge.getSource().table, edge.getTarget().table, edge.pairs);
                    node = new MutableNode(vertex.table, parent, step);
                    node.alias = vertex.alias;
                }
                map.put(vertex.table, node);
            }
            assert (root != null);
            Fixer fixer = new Fixer();
            fixer.fixUp(root);
            this.baseColumns = fixer.columnList.build();
            this.columnsByAlias = fixer.columnAliasList.build();
            this.rootNode = new LatticeRootNode(space, root);
        }

        Builder(LatticeSpace space, CalciteSchema schema, MutableNode mutableNode) {
            LatticeRootNode node;
            this.rootSchema = schema;
            Fixer fixer = new Fixer();
            fixer.fixUp(mutableNode);
            LatticeRootNode node0 = new LatticeRootNode(space, mutableNode);
            LatticeRootNode node1 = space.nodeMap.get(node0.digest);
            if (node1 != null) {
                node = node1;
            } else {
                node = node0;
                space.nodeMap.put(node0.digest, node0);
            }
            this.rootNode = node;
            this.baseColumns = fixer.columnList.build();
            this.columnsByAlias = fixer.columnAliasList.build();
        }

        public Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public Builder algorithm(boolean algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder algorithmMaxMillis(long algorithmMaxMillis) {
            this.algorithmMaxMillis = algorithmMaxMillis;
            return this;
        }

        public Builder rowCountEstimate(double rowCountEstimate) {
            this.rowCountEstimate = rowCountEstimate;
            return this;
        }

        public Builder statisticProvider(String statisticProvider) {
            this.statisticProvider = statisticProvider;
            return this;
        }

        public Lattice build() {
            LatticeStatisticProvider.Factory statisticProvider = this.statisticProvider != null ? AvaticaUtils.instantiatePlugin(LatticeStatisticProvider.Factory.class, this.statisticProvider) : Lattices.CACHED_SQL;
            Preconditions.checkArgument(this.rootSchema.isRoot(), "must be root schema");
            ImmutableCollection.Builder columnBuilder = ((ImmutableList.Builder)ImmutableList.builder().addAll(this.baseColumns)).addAll(this.derivedColumnsByName.values());
            return new Lattice(this.rootSchema, this.rootNode, this.auto, this.algorithm, this.algorithmMaxMillis, statisticProvider, this.rowCountEstimate, (ImmutableList)((ImmutableList.Builder)columnBuilder).build(), ImmutableSortedSet.copyOf(this.defaultMeasureSet), (ImmutableList)this.tileListBuilder.build(), ImmutableListMultimap.copyOf(this.columnUses));
        }

        public ImmutableList<Column> resolveArgs(@Nullable Object args) {
            if (args == null) {
                return ImmutableList.of();
            }
            if (args instanceof String) {
                return ImmutableList.of(this.resolveColumnByAlias((String)args));
            }
            if (args instanceof List) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object o : (List)args) {
                    if (o instanceof String) {
                        builder.add(this.resolveColumnByAlias((String)o));
                        continue;
                    }
                    throw new RuntimeException("Measure arguments must be a string or a list of strings; argument: " + o);
                }
                return builder.build();
            }
            throw new RuntimeException("Measure arguments must be a string or a list of strings");
        }

        private Column resolveColumnByAlias(String name) {
            ImmutableCollection list = this.columnsByAlias.get((Object)name);
            if (list == null || list.size() == 0) {
                throw new RuntimeException("Unknown lattice column '" + name + "'");
            }
            if (list.size() == 1) {
                return (Column)list.get(0);
            }
            throw new RuntimeException("Lattice column alias '" + name + "' is not unique");
        }

        public Column resolveColumn(Object name) {
            if (name instanceof String) {
                return this.resolveColumnByAlias((String)name);
            }
            if (name instanceof List) {
                List list = (List)name;
                switch (list.size()) {
                    case 1: {
                        Object alias = list.get(0);
                        if (!(alias instanceof String)) break;
                        return this.resolveColumnByAlias((String)alias);
                    }
                    case 2: {
                        Object table = list.get(0);
                        Object column = list.get(1);
                        if (!(table instanceof String) || !(column instanceof String)) break;
                        return this.resolveQualifiedColumn((String)table, (String)column);
                    }
                }
            }
            throw new RuntimeException("Lattice column reference must be a string or a list of 1 or 2 strings; column: " + name);
        }

        private Column resolveQualifiedColumn(String table, String column) {
            for (BaseColumn column1 : this.baseColumns) {
                if (!column1.table.equals(table) || !column1.column.equals(column)) continue;
                return column1;
            }
            throw new RuntimeException("Unknown lattice column [" + table + ", " + column + "]");
        }

        public Measure resolveMeasure(String aggName, boolean distinct, @Nullable Object args) {
            SqlAggFunction agg = this.resolveAgg(aggName);
            ImmutableList<Column> list = this.resolveArgs(args);
            return new Measure(agg, distinct, aggName, list);
        }

        private SqlAggFunction resolveAgg(String aggName) {
            if (aggName.equalsIgnoreCase("count")) {
                return SqlStdOperatorTable.COUNT;
            }
            if (aggName.equalsIgnoreCase("sum")) {
                return SqlStdOperatorTable.SUM;
            }
            throw new RuntimeException("Unknown lattice aggregate function " + aggName);
        }

        public boolean addMeasure(Measure measure) {
            return this.defaultMeasureSet.add(measure);
        }

        public void addTile(Tile tile) {
            this.tileListBuilder.add((Object)tile);
        }

        public Column column(int table, int column) {
            int i = 0;
            for (LatticeNode descendant : this.rootNode.descendants) {
                if (table-- == 0) break;
                i += descendant.table.t.getRowType().getFieldCount();
            }
            return (Column)this.baseColumns.get(i + column);
        }

        Column pathOffsetToColumn(Path path, int offset) {
            int i = this.rootNode.paths.indexOf(path);
            LatticeNode node = (LatticeNode)this.rootNode.descendants.get(i);
            int c = node.startCol + offset;
            if (c >= node.endCol) {
                throw new AssertionError();
            }
            return (Column)this.baseColumns.get(c);
        }

        public Column expression(RexNode e, String alias, List<String> tableAliases) {
            return this.derivedColumnsByName.computeIfAbsent(e.toString(), k -> {
                int derivedOrdinal = this.derivedColumnsByName.size();
                int ordinal = this.baseColumns.size() + derivedOrdinal;
                return new DerivedColumn(ordinal, Util.first(alias, "e$" + derivedOrdinal), e, tableAliases);
            });
        }

        public void use(Column column, boolean measure) {
            this.columnUses.put(column.ordinal, measure);
        }

        private static class Fixer {
            final Set<String> aliases = new HashSet<String>();
            final Set<String> columnAliases = new HashSet<String>();
            final Set<MutableNode> seen = new HashSet<MutableNode>();
            final ImmutableList.Builder<BaseColumn> columnList = ImmutableList.builder();
            final ImmutableListMultimap.Builder<String, Column> columnAliasList = ImmutableListMultimap.builder();
            int c;

            private Fixer() {
            }

            void fixUp(MutableNode node) {
                if (!this.seen.add(node)) {
                    throw new IllegalArgumentException("cyclic query graph");
                }
                if (node.alias == null) {
                    node.alias = Util.last(node.table.t.getQualifiedName());
                }
                node.alias = SqlValidatorUtil.uniquify(node.alias, this.aliases, SqlValidatorUtil.ATTEMPT_SUGGESTER);
                node.startCol = this.c;
                for (String name : node.table.t.getRowType().getFieldNames()) {
                    String alias = SqlValidatorUtil.uniquify(name, this.columnAliases, SqlValidatorUtil.ATTEMPT_SUGGESTER);
                    BaseColumn column = new BaseColumn(this.c++, node.alias, name, alias);
                    this.columnList.add((Object)column);
                    this.columnAliasList.put((Object)name, (Object)column);
                }
                node.endCol = this.c;
                assert (MutableNode.ORDERING.isStrictlyOrdered(node.children)) : node.children;
                for (MutableNode child : node.children) {
                    this.fixUp(child);
                }
            }
        }
    }

    public static class Measure
    implements Comparable<Measure> {
        public final SqlAggFunction agg;
        public final boolean distinct;
        @Nullable
        public final String name;
        public final ImmutableList<Column> args;
        public final String digest;

        public Measure(SqlAggFunction agg, boolean distinct, @Nullable String name, Iterable<Column> args) {
            this.agg = Objects.requireNonNull(agg);
            this.distinct = distinct;
            this.name = name;
            this.args = ImmutableList.copyOf(args);
            StringBuilder b = new StringBuilder().append(agg).append(distinct ? "(DISTINCT " : "(");
            for (Ord<Column> arg : Ord.zip(this.args)) {
                if (arg.i > 0) {
                    b.append(", ");
                }
                if (arg.e instanceof BaseColumn) {
                    b.append(((BaseColumn)arg.e).table);
                    b.append('.');
                    b.append(((BaseColumn)arg.e).column);
                    continue;
                }
                b.append(((Column)arg.e).alias);
            }
            b.append(')');
            this.digest = b.toString();
        }

        @Override
        public int compareTo(@Nonnull Measure measure) {
            int c = Measure.compare(this.args, measure.args);
            if (c == 0 && (c = this.agg.getName().compareTo(measure.agg.getName())) == 0) {
                c = Boolean.compare(this.distinct, measure.distinct);
            }
            return c;
        }

        public String toString() {
            return this.digest;
        }

        public int hashCode() {
            return Objects.hash(this.agg, this.args);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Measure && this.agg.equals(((Measure)obj).agg) && this.args.equals(((Measure)obj).args) && this.distinct == ((Measure)obj).distinct;
        }

        public ImmutableBitSet argBitSet() {
            ImmutableBitSet.Builder bitSet = ImmutableBitSet.builder();
            for (Column arg : this.args) {
                bitSet.set(arg.ordinal);
            }
            return bitSet.build();
        }

        public List<Integer> argOrdinals() {
            return Lists.transform(this.args, column -> column.ordinal);
        }

        private static int compare(List<Column> list0, List<Column> list1) {
            int size = Math.min(list0.size(), list1.size());
            for (int i = 0; i < size; ++i) {
                int o0 = list0.get((int)i).ordinal;
                int o1 = list1.get((int)i).ordinal;
                int c = Utilities.compare(o0, o1);
                if (c == 0) continue;
                return c;
            }
            return Utilities.compare(list0.size(), list1.size());
        }

        Measure copy(Function<Column, Column> mapper) {
            return new Measure(this.agg, this.distinct, this.name, Util.transform(this.args, mapper));
        }
    }

    public static abstract class Column
    implements Comparable<Column> {
        public final int ordinal;
        public final String alias;

        private Column(int ordinal, String alias) {
            this.ordinal = ordinal;
            this.alias = Objects.requireNonNull(alias);
        }

        static ImmutableBitSet toBitSet(List<Column> columns) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (Column column : columns) {
                builder.set(column.ordinal);
            }
            return builder.build();
        }

        @Override
        public int compareTo(Column column) {
            return Utilities.compare(this.ordinal, column.ordinal);
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Column && this.ordinal == ((Column)obj).ordinal;
        }

        public abstract void toSql(SqlWriter var1);

        public abstract String defaultAlias();
    }

    public static class SqlWriter {
        public final Lattice lattice;
        public final StringBuilder buf;
        public final SqlDialect dialect;
        private final SqlImplementor.SimpleContext context;

        SqlWriter(Lattice lattice, SqlDialect dialect, StringBuilder buf, SqlImplementor.SimpleContext context) {
            this.lattice = lattice;
            this.context = context;
            this.buf = buf;
            this.dialect = dialect;
        }

        public SqlWriter with(StringBuilder buf) {
            return new SqlWriter(this.lattice, this.dialect, buf, this.context);
        }

        public SqlWriter write(RexNode e) {
            SqlNode node = this.context.toSql(null, e);
            this.buf.append(node.toSqlString(this.dialect));
            return this;
        }
    }

    public static class BaseColumn
    extends Column {
        public final String table;
        @Nonnull
        public final String column;

        private BaseColumn(int ordinal, String table, String column, String alias) {
            super(ordinal, alias);
            this.table = Objects.requireNonNull(table);
            this.column = Objects.requireNonNull(column);
        }

        public String toString() {
            return this.identifiers().toString();
        }

        public List<String> identifiers() {
            return ImmutableList.of(this.table, this.column);
        }

        @Override
        public void toSql(SqlWriter writer) {
            writer.dialect.quoteIdentifier(writer.buf, this.identifiers());
        }

        @Override
        public String defaultAlias() {
            return this.column;
        }
    }

    public static class TileBuilder {
        private final List<Measure> measureBuilder = new ArrayList<Measure>();
        private final List<Column> dimensionListBuilder = new ArrayList<Column>();

        public Tile build() {
            return new Tile(Ordering.natural().immutableSortedCopy(this.measureBuilder), Ordering.natural().immutableSortedCopy(this.dimensionListBuilder));
        }

        public void addMeasure(Measure measure) {
            this.measureBuilder.add(measure);
        }

        public void addDimension(Column column) {
            this.dimensionListBuilder.add(column);
        }
    }

    public static class Tile {
        public final ImmutableList<Measure> measures;
        public final ImmutableList<Column> dimensions;
        public final ImmutableBitSet bitSet;

        public Tile(ImmutableList<Measure> measures, ImmutableList<Column> dimensions) {
            this.measures = Objects.requireNonNull(measures);
            this.dimensions = Objects.requireNonNull(dimensions);
            assert (Ordering.natural().isStrictlyOrdered(dimensions));
            assert (Ordering.natural().isStrictlyOrdered(measures));
            this.bitSet = Column.toBitSet(dimensions);
        }

        public static TileBuilder builder() {
            return new TileBuilder();
        }

        public ImmutableBitSet bitSet() {
            return this.bitSet;
        }
    }

    public static class DerivedColumn
    extends Column {
        @Nonnull
        public final RexNode e;
        @Nonnull
        final List<String> tables;

        private DerivedColumn(int ordinal, String alias, RexNode e, List<String> tables) {
            super(ordinal, alias);
            this.e = e;
            this.tables = ImmutableList.copyOf(tables);
        }

        public String toString() {
            return Arrays.toString(new Object[]{this.e, this.alias});
        }

        @Override
        public void toSql(SqlWriter writer) {
            writer.write(this.e);
        }

        @Override
        public String defaultAlias() {
            return null;
        }
    }

    private static class Vertex {
        final LatticeTable table;
        final String alias;

        private Vertex(LatticeTable table, String alias) {
            this.table = table;
            this.alias = alias;
        }
    }

    private static class Edge
    extends DefaultEdge {
        public static final DirectedGraph.EdgeFactory<Vertex, Edge> FACTORY = Edge::new;
        final List<IntPair> pairs = new ArrayList<IntPair>();

        Edge(Vertex source, Vertex target) {
            super(source, target);
        }

        Vertex getTarget() {
            return (Vertex)this.target;
        }

        Vertex getSource() {
            return (Vertex)this.source;
        }
    }
}

