/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.function.Function;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.LambdaExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;

public final class FunctionExpression<F extends Function<?>>
extends LambdaExpression {
    public final F function;
    public final BlockStatement body;
    public final List<ParameterExpression> parameterList;
    private F dynamicFunction;
    private int hash;

    private FunctionExpression(Class<F> type, F function, BlockStatement body, List<ParameterExpression> parameterList) {
        super(ExpressionType.Lambda, type);
        assert (type != null) : "type should not be null";
        assert (function != null || body != null) : "both function and body should not be null";
        assert (parameterList != null) : "parameterList should not be null";
        this.function = function;
        this.body = body;
        this.parameterList = parameterList;
    }

    public FunctionExpression(F function) {
        this(function.getClass(), function, null, ImmutableList.of());
    }

    public FunctionExpression(Class<F> type, BlockStatement body, List<ParameterExpression> parameters) {
        this(type, null, body, parameters);
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    public Invokable compile() {
        return args -> {
            Evaluator evaluator = new Evaluator();
            for (int i = 0; i < args.length; ++i) {
                evaluator.push(this.parameterList.get(i), args[i]);
            }
            return evaluator.evaluate(this.body);
        };
    }

    public F getFunction() {
        if (this.function != null) {
            return this.function;
        }
        if (this.dynamicFunction == null) {
            Invokable x = this.compile();
            this.dynamicFunction = (Function)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Types.toClass(this.type)}, (proxy, method, args) -> x.dynamicInvoke(args));
        }
        return this.dynamicFunction;
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        String bridgeResultTypeName;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> bridgeParams = new ArrayList<String>();
        ArrayList<String> bridgeArgs = new ArrayList<String>();
        ArrayList<String> boxBridgeParams = new ArrayList<String>();
        ArrayList<String> boxBridgeArgs = new ArrayList<String>();
        for (ParameterExpression parameterExpression : this.parameterList) {
            Type parameterType = parameterExpression.getType();
            Type parameterBoxType = Types.box(parameterType);
            String parameterBoxTypeName = Types.className(parameterBoxType);
            params.add(parameterExpression.declString());
            bridgeParams.add(parameterExpression.declString((Type)((Object)Object.class)));
            bridgeArgs.add("(" + parameterBoxTypeName + ") " + parameterExpression.name);
            boxBridgeParams.add(parameterExpression.declString(parameterBoxType));
            boxBridgeArgs.add(parameterExpression.name + (Primitive.is(parameterType) ? "." + Primitive.of((Type)parameterType).primitiveName + "Value()" : ""));
        }
        Type bridgeResultType = Functions.FUNCTION_RESULT_TYPES.get(this.type);
        if (bridgeResultType == null) {
            bridgeResultType = this.body.getType();
        }
        Type resultType2 = bridgeResultType;
        if (bridgeResultType == Object.class && !params.equals(bridgeParams) && !(this.body.getType() instanceof TypeVariable)) {
            resultType2 = this.body.getType();
        }
        String methodName = this.getAbstractMethodName();
        writer.append("new ").append(this.type).append("()").begin(" {\n").append("public ").append(Types.className(resultType2)).list(" " + methodName + "(", ", ", ") ", params).append(Blocks.toFunctionBlock(this.body));
        String string = bridgeResultTypeName = this.isAbstractMethodPrimitive() ? Types.className(bridgeResultType) : Types.className(Types.box(bridgeResultType));
        if (!boxBridgeParams.equals(params)) {
            writer.append("public ").append(bridgeResultTypeName).list(" " + methodName + "(", ", ", ") ", boxBridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", boxBridgeArgs).end("}\n");
        }
        if (!bridgeParams.equals(params)) {
            writer.append("public ").append(bridgeResultTypeName).list(" " + methodName + "(", ", ", ") ", bridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", bridgeArgs).end("}\n");
        }
        writer.end("}\n");
    }

    private boolean isAbstractMethodPrimitive() {
        Method method = this.getAbstractMethod();
        assert (method != null);
        return Primitive.is(method.getReturnType());
    }

    private String getAbstractMethodName() {
        Method abstractMethod = this.getAbstractMethod();
        assert (abstractMethod != null);
        return abstractMethod.getName();
    }

    private Method getAbstractMethod() {
        if (this.type instanceof Class && ((Class)this.type).isInterface()) {
            ArrayList<Method> declaredMethods = Lists.newArrayList(((Class)this.type).getDeclaredMethods());
            declaredMethods.removeIf(m -> (m.getModifiers() & 0x1000) != 0);
            if (declaredMethods.size() == 1) {
                return (Method)declaredMethods.get(0);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionExpression that = (FunctionExpression)o;
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
            return false;
        }
        return this.parameterList.equals(that.parameterList);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.function, this.body, this.parameterList});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }

    public static interface Invokable {
        public Object dynamicInvoke(Object ... var1);
    }
}

