/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.clone;

import com.linkedin.coral.com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.clone.ArrayTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelProtoDataType;

class ColumnLoader<T> {
    static final int[] INT_B = new int[]{2, 12, 240, 65280, -65536};
    static final int[] INT_S = new int[]{1, 2, 4, 8, 16};
    static final long[] LONG_B = new long[]{2L, 12L, 240L, 65280L, -65536L, -4294967296L};
    static final int[] LONG_S = new int[]{1, 2, 4, 8, 16, 32};
    public final List<T> list = new ArrayList<T>();
    public final List<ArrayTable.Column> representationValues = new ArrayList<ArrayTable.Column>();
    private final JavaTypeFactory typeFactory;
    public final int sortField;

    ColumnLoader(JavaTypeFactory typeFactory, Enumerable<T> sourceTable, RelProtoDataType protoRowType, List<ColumnMetaData.Rep> repList) {
        this.typeFactory = typeFactory;
        RelDataType rowType = (RelDataType)protoRowType.apply(typeFactory);
        if (repList == null) {
            repList = Collections.nCopies(rowType.getFieldCount(), ColumnMetaData.Rep.OBJECT);
        }
        sourceTable.into(this.list);
        int[] sorts = new int[]{-1};
        this.load(rowType, repList, sorts);
        this.sortField = sorts[0];
    }

    static int nextPowerOf2(int v) {
        --v;
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        return ++v;
    }

    static long nextPowerOf2(long v) {
        --v;
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        v |= v >>> 32;
        return ++v;
    }

    static int log2(int v) {
        int r = 0;
        for (int i = 4; i >= 0; --i) {
            if ((v & INT_B[i]) == 0) continue;
            v >>= INT_S[i];
            r |= INT_S[i];
        }
        return r;
    }

    static int log2(long v) {
        int r = 0;
        for (int i = 5; i >= 0; --i) {
            if ((v & LONG_B[i]) == 0L) continue;
            v >>= LONG_S[i];
            r |= LONG_S[i];
        }
        return r;
    }

    static int[] invert(int[] targets) {
        int[] sources = new int[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            sources[targets[i]] = i;
        }
        return sources;
    }

    static boolean isIdentity(int[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i] == i) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.list.size();
    }

    private void load(final RelDataType elementType, List<ColumnMetaData.Rep> repList, int[] sort) {
        AbstractList<Type> types = new AbstractList<Type>(){
            final List<RelDataTypeField> fields;
            {
                this.fields = elementType.getFieldList();
            }

            @Override
            public Type get(int index) {
                return ColumnLoader.this.typeFactory.getJavaClass(this.fields.get(index).getType());
            }

            @Override
            public int size() {
                return this.fields.size();
            }
        };
        int[] sources = null;
        for (final Ord<Type> pair : Ord.zip(types)) {
            AbstractList<Object> sliceList = types.size() == 1 ? this.list : new AbstractList<Object>(){
                final int slice;
                {
                    this.slice = pair.i;
                }

                @Override
                public Object get(int index) {
                    return ((Object[])ColumnLoader.this.list.get(index))[this.slice];
                }

                @Override
                public int size() {
                    return ColumnLoader.this.list.size();
                }
            };
            List list2 = ColumnLoader.wrap(repList.get(pair.i), sliceList, elementType.getFieldList().get(pair.i).getType());
            Class clazz = pair.e instanceof Class ? (Class)pair.e : Object.class;
            ValueSet valueSet = new ValueSet(clazz);
            for (Object o : list2) {
                valueSet.add((Comparable)o);
            }
            if (sort != null && sort[0] < 0 && valueSet.map.keySet().size() == this.list.size()) {
                int i;
                sort[0] = pair.i;
                Comparable[] values = valueSet.values.toArray(new Comparable[this.list.size()]);
                Object[] kevs = new Kev[this.list.size()];
                for (i = 0; i < kevs.length; ++i) {
                    kevs[i] = new Kev(i, values[i]);
                }
                Arrays.sort(kevs);
                sources = new int[this.list.size()];
                for (i = 0; i < sources.length; ++i) {
                    sources[i] = ((Kev)kevs[i]).source;
                }
                if (ColumnLoader.isIdentity(sources)) {
                    sources = null;
                } else {
                    for (i = 0; i < pair.i; ++i) {
                        this.representationValues.set(i, this.representationValues.get(i).permute(sources));
                    }
                }
            }
            this.representationValues.add(valueSet.freeze(pair.i, sources));
        }
    }

    private static List wrap(ColumnMetaData.Rep rep, List list, RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TIMESTAMP: {
                switch (rep) {
                    case OBJECT: 
                    case JAVA_SQL_TIMESTAMP: {
                        return Lists.transform(list, t -> t == null ? null : Long.valueOf(t.getTime()));
                    }
                }
                break;
            }
            case TIME: {
                switch (rep) {
                    case OBJECT: 
                    case JAVA_SQL_TIME: {
                        return Lists.transform(list, t -> t == null ? null : Integer.valueOf((int)(t.getTime() % 86400000L)));
                    }
                }
                break;
            }
            case DATE: {
                switch (rep) {
                    case OBJECT: 
                    case JAVA_SQL_DATE: {
                        return Lists.transform(list, d -> d == null ? null : Integer.valueOf((int)(d.getTime() / 86400000L)));
                    }
                }
            }
        }
        return list;
    }

    static class ValueSet {
        final Class clazz;
        final Map<Comparable, Comparable> map = new HashMap<Comparable, Comparable>();
        final List<Comparable> values = new ArrayList<Comparable>();
        Comparable min;
        Comparable max;
        boolean containsNull;

        ValueSet(Class clazz) {
            this.clazz = clazz;
        }

        void add(Comparable e) {
            if (e != null) {
                Comparable old = e;
                if ((e = this.map.get(e)) == null) {
                    e = old;
                    this.map.put(e, e);
                    if (this.min == null || this.min.compareTo(e) > 0) {
                        this.min = e;
                    }
                    if (this.max == null || this.max.compareTo(e) < 0) {
                        this.max = e;
                    }
                }
            } else {
                this.containsNull = true;
            }
            this.values.add(e);
        }

        ArrayTable.Column freeze(int ordinal, int[] sources) {
            ArrayTable.Representation representation = this.chooseRep(ordinal);
            int cardinality = this.map.size() + (this.containsNull ? 1 : 0);
            Object data = representation.freeze(this, sources);
            return new ArrayTable.Column(representation, data, cardinality);
        }

        ArrayTable.Representation chooseRep(int ordinal) {
            int codeCount;
            int codeBitCount;
            Primitive p;
            Primitive primitive = Primitive.of(this.clazz);
            Primitive boxPrimitive = Primitive.ofBox(this.clazz);
            Primitive primitive2 = p = primitive != null ? primitive : boxPrimitive;
            if (!this.containsNull && p != null) {
                switch (p) {
                    case FLOAT: 
                    case DOUBLE: {
                        return new ArrayTable.PrimitiveArray(ordinal, p, p);
                    }
                    case OTHER: 
                    case VOID: {
                        throw new AssertionError((Object)"wtf?!");
                    }
                }
                if (this.canBeLong(this.min) && this.canBeLong(this.max)) {
                    return this.chooseFixedRep(ordinal, p, this.toLong(this.min), this.toLong(this.max));
                }
            }
            if ((codeBitCount = ColumnLoader.log2(ColumnLoader.nextPowerOf2(codeCount = this.map.size() + (this.containsNull ? 1 : 0)))) < 10 && this.values.size() > 2000) {
                ArrayTable.Representation representation = this.chooseFixedRep(-1, Primitive.INT, 0L, codeCount - 1);
                return new ArrayTable.ObjectDictionary(ordinal, representation);
            }
            return new ArrayTable.ObjectArray(ordinal);
        }

        private long toLong(Object o) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return ((Number)o).longValue();
        }

        private boolean canBeLong(Object o) {
            return o instanceof Boolean || o instanceof Character || o instanceof Number;
        }

        private ArrayTable.Representation chooseFixedRep(int ordinal, Primitive p, long min, long max) {
            int bitCount;
            boolean signed;
            if (min == max) {
                return new ArrayTable.Constant(ordinal);
            }
            int bitCountMax = ColumnLoader.log2(ColumnLoader.nextPowerOf2(ValueSet.abs2(max) + 1L));
            if (min >= 0L) {
                signed = false;
                bitCount = bitCountMax;
            } else {
                signed = true;
                int bitCountMin = ColumnLoader.log2(ColumnLoader.nextPowerOf2(ValueSet.abs2(min) + 1L));
                bitCount = Math.max(bitCountMin, bitCountMax) + 1;
            }
            if (bitCount > 21 && bitCount < 32) {
                signed = true;
                bitCount = 32;
            }
            if (bitCount >= 33 && bitCount < 64) {
                signed = true;
                bitCount = 64;
            }
            if (signed) {
                switch (bitCount) {
                    case 8: {
                        return new ArrayTable.PrimitiveArray(ordinal, Primitive.BYTE, p);
                    }
                    case 16: {
                        return new ArrayTable.PrimitiveArray(ordinal, Primitive.SHORT, p);
                    }
                    case 32: {
                        return new ArrayTable.PrimitiveArray(ordinal, Primitive.INT, p);
                    }
                    case 64: {
                        return new ArrayTable.PrimitiveArray(ordinal, Primitive.LONG, p);
                    }
                }
            }
            return new ArrayTable.BitSlicedPrimitiveArray(ordinal, bitCount, p, signed);
        }

        private static int abs2(int v) {
            return v < 0 ? ~v : v;
        }

        private static long abs2(long v) {
            return v < 0L ? v ^ 0xFFFFFFFFFFFFFFFFL : v;
        }
    }

    private static class Kev
    implements Comparable<Kev> {
        private final int source;
        private final Comparable key;

        Kev(int source, Comparable key) {
            this.source = source;
            this.key = key;
        }

        @Override
        public int compareTo(Kev o) {
            return this.key.compareTo(o.key);
        }
    }
}

