/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public final class Wkid {
    static ArrayList<Double> m_gcs_tolerances = Wkid.readTolerances("gcs_tolerances.txt");
    static ArrayList<Double> m_pcs_tolerances = Wkid.readTolerances("pcs_tolerances.txt");
    static HashMap<Integer, Integer> m_gcsToTol = Wkid.readToleranceMap("gcs_id_to_tolerance.txt");
    static HashMap<Integer, Integer> m_pcsToTol = Wkid.readToleranceMap("pcs_id_to_tolerance.txt");
    static HashMap<Integer, Integer> m_wkid_to_new;
    static HashMap<Integer, Integer> m_wkid_to_old;

    static ArrayList<Double> readTolerances(String resourceName) {
        try {
            String s;
            ArrayList<Double> tolerances = new ArrayList<Double>();
            InputStream input = Wkid.class.getResourceAsStream(resourceName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((s = reader.readLine()) != null) {
                int sep = s.indexOf(9, 0);
                String id_s = s.substring(0, sep);
                int tol_index = Integer.parseInt(id_s);
                if (tol_index != tolerances.size()) {
                    throw new IllegalArgumentException("Wkid.readTolerances");
                }
                String tol_val = s.substring(sep + 1, s.length());
                tolerances.add(Double.parseDouble(tol_val));
            }
            return tolerances;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static HashMap<Integer, Integer> readToleranceMap(String resourceName) {
        try {
            String s;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(600);
            InputStream input = Wkid.class.getResourceAsStream(resourceName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((s = reader.readLine()) != null) {
                int sep = s.indexOf(9, 0);
                String id_s = s.substring(0, sep);
                int wkid = Integer.parseInt(id_s);
                String id_t = s.substring(sep + 1, s.length());
                int tol = Integer.parseInt(id_t);
                hashMap.put(wkid, tol);
            }
            return hashMap;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static double find_tolerance_from_wkid(int wkid) {
        double tol = Wkid.find_tolerance_from_wkid_helper(wkid);
        if (tol == 1.0E38) {
            int old = Wkid.wkid_to_old(wkid);
            if (old != wkid) {
                tol = Wkid.find_tolerance_from_wkid_helper(old);
            }
            if (tol == 1.0E38) {
                return 1.0E-10;
            }
        }
        return tol;
    }

    private static double find_tolerance_from_wkid_helper(int wkid) {
        if (m_gcsToTol.containsKey(wkid)) {
            return m_gcs_tolerances.get(m_gcsToTol.get(wkid));
        }
        if (m_pcsToTol.containsKey(wkid)) {
            return m_pcs_tolerances.get(m_pcsToTol.get(wkid));
        }
        return 1.0E38;
    }

    public static int wkid_to_new(int wkid) {
        if (m_wkid_to_new.containsKey(wkid)) {
            return m_wkid_to_new.get(wkid);
        }
        return wkid;
    }

    public static int wkid_to_old(int wkid) {
        if (m_wkid_to_old.containsKey(wkid)) {
            return m_wkid_to_old.get(wkid);
        }
        return wkid;
    }

    static {
        try {
            int wkid_old;
            String id_t;
            String id_s;
            int sep;
            String s;
            m_wkid_to_new = new HashMap(100);
            m_wkid_to_old = new HashMap(100);
            InputStream input = Wkid.class.getResourceAsStream("new_to_old_wkid.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                sep = s.indexOf(9, 0);
                id_s = s.substring(0, sep);
                int wkid_new = Integer.parseInt(id_s);
                id_t = s.substring(sep + 1, s.length());
                wkid_old = Integer.parseInt(id_t);
                m_wkid_to_new.put(wkid_old, wkid_new);
                m_wkid_to_old.put(wkid_new, wkid_old);
            }
            input = Wkid.class.getResourceAsStream("intermediate_to_old_wkid.txt");
            reader = new BufferedReader(new InputStreamReader(input));
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                sep = s.indexOf(9, 0);
                id_s = s.substring(0, sep);
                int wkid = Integer.parseInt(id_s);
                id_t = s.substring(sep + 1, s.length());
                wkid_old = Integer.parseInt(id_t);
                m_wkid_to_old.put(wkid, wkid_old);
                m_wkid_to_new.put(wkid, m_wkid_to_new.get(wkid_old));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

