/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope3D;
import com.linkedin.coral.com.esri.core.geometry.GeometryException;
import com.linkedin.coral.com.esri.core.geometry.Point3D;

final class Transformation3D {
    public double xx;
    public double yx;
    public double zx;
    public double xd;
    public double xy;
    public double yy;
    public double zy;
    public double yd;
    public double xz;
    public double yz;
    public double zz;
    public double zd;

    public void setZero() {
        this.xx = 0.0;
        this.yx = 0.0;
        this.zx = 0.0;
        this.xy = 0.0;
        this.yy = 0.0;
        this.zy = 0.0;
        this.xz = 0.0;
        this.yz = 0.0;
        this.zz = 0.0;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void setScale(double scaleX, double scaleY, double scaleZ) {
        this.xx = scaleX;
        this.yx = 0.0;
        this.zx = 0.0;
        this.xy = 0.0;
        this.yy = scaleY;
        this.zy = 0.0;
        this.xz = 0.0;
        this.yz = 0.0;
        this.zz = scaleZ;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void setTranslate(double deltax, double deltay, double deltaz) {
        this.xx = 1.0;
        this.yx = 0.0;
        this.zx = 0.0;
        this.xy = 0.0;
        this.yy = 1.0;
        this.zy = 0.0;
        this.xz = 0.0;
        this.yz = 0.0;
        this.zz = 1.0;
        this.xd = deltax;
        this.yd = deltay;
        this.zd = deltaz;
    }

    public void translate(double deltax, double deltay, double deltaz) {
        this.xd += deltax;
        this.yd += deltay;
        this.zd += deltaz;
    }

    public Envelope3D transform(Envelope3D env) {
        if (env.isEmpty()) {
            return env;
        }
        Point3D[] buf = new Point3D[8];
        env.queryCorners(buf);
        this.transform(buf, 8, buf);
        env.setFromPoints(buf);
        return env;
    }

    void transform(Point3D[] pointsIn, int count, Point3D[] pointsOut) {
        for (int i = 0; i < count; ++i) {
            Point3D res = new Point3D();
            Point3D src = pointsIn[i];
            res.x = this.xx * src.x + this.xy * src.y + this.xz * src.z + this.xd;
            res.y = this.yx * src.x + this.yy * src.y + this.yz * src.z + this.yd;
            res.z = this.zx * src.x + this.zy * src.y + this.zz * src.z + this.zd;
            pointsOut[i] = res;
        }
    }

    public Point3D transform(Point3D src) {
        Point3D res = new Point3D();
        res.x = this.xx * src.x + this.xy * src.y + this.xz * src.z + this.xd;
        res.y = this.yx * src.x + this.yy * src.y + this.yz * src.z + this.yd;
        res.z = this.zx * src.x + this.zy * src.y + this.zz * src.z + this.zd;
        return res;
    }

    public void transform(Point3D[] points, int start, int count) {
        int n = Math.min(points.length, start + count);
        for (int i = start; i < n; ++i) {
            Point3D res = new Point3D();
            Point3D src = points[i];
            res.x = this.xx * src.x + this.xy * src.y + this.xz * src.z + this.xd;
            res.y = this.yx * src.x + this.yy * src.y + this.yz * src.z + this.yd;
            res.z = this.zx * src.x + this.zy * src.y + this.zz * src.z + this.zd;
            points[i] = res;
        }
    }

    public void mul(Transformation3D right) {
        Transformation3D.multiply(this, right, this);
    }

    public void mulLeft(Transformation3D left) {
        Transformation3D.multiply(left, this, this);
    }

    public static void multiply(Transformation3D a, Transformation3D b, Transformation3D result) {
        double xx = a.xx * b.xx + a.yx * b.xy + a.zx * b.xz;
        double yx = a.xx * b.yx + a.yx * b.yy + a.zx * b.yz;
        double zx = a.xx * b.zx + a.yx * b.zy + a.zx * b.zz;
        double xy = a.xy * b.xx + a.yy * b.xy + a.zy * b.xz;
        double yy = a.xy * b.yx + a.yy * b.yy + a.zy * b.yz;
        double zy = a.xy * b.zx + a.yy * b.zy + a.zy * b.zz;
        double xz = a.xz * b.xx + a.yz * b.xy + a.zz * b.xz;
        double yz = a.xz * b.yx + a.yz * b.yy + a.zz * b.yz;
        double zz = a.xz * b.zx + a.yz * b.zy + a.zz * b.zz;
        double xd = a.xd * b.xx + a.yd * b.xy + a.zd * b.xz + b.xd;
        double yd = a.xd * b.yx + a.yd * b.yy + a.zd * b.yz + b.yd;
        double zd = a.xd * b.zx + a.yd * b.zy + a.zd * b.zz + b.zd;
        result.xx = xx;
        result.yx = yx;
        result.zx = zx;
        result.xy = xy;
        result.yy = yy;
        result.zy = zy;
        result.xz = xz;
        result.yz = yz;
        result.zz = zz;
        result.xd = xd;
        result.yd = yd;
        result.zd = zd;
    }

    public static void inverse(Transformation3D src, Transformation3D result) {
        double det = src.xx * (src.yy * src.zz - src.zy * src.yz) - src.yx * (src.xy * src.zz - src.zy * src.xz) + src.zx * (src.xy * src.yz - src.yy * src.xz);
        if (det == 0.0) {
            throw new GeometryException("math singularity");
        }
        double det_1 = 1.0 / det;
        double xx = (src.yy * src.zz - src.zy * src.yz) * det_1;
        double xy = -(src.xy * src.zz - src.zy * src.xz) * det_1;
        double xz = (src.xy * src.yz - src.yy * src.xz) * det_1;
        double yx = -(src.yx * src.zz - src.yz * src.zx) * det_1;
        double yy = (src.xx * src.zz - src.zx * src.xz) * det_1;
        double yz = -(src.xx * src.yz - src.yx * src.xz) * det_1;
        double zx = (src.yx * src.zy - src.zx * src.yy) * det_1;
        double zy = -(src.xx * src.zy - src.zx * src.xy) * det_1;
        double zz = (src.xx * src.yy - src.yx * src.xy) * det_1;
        double xd = -(src.xd * xx + src.yd * xy + src.zd * xz);
        double yd = -(src.xd * yx + src.yd * yy + src.zd * yz);
        double zd = -(src.xd * zx + src.yd * zy + src.zd * zz);
        result.xx = xx;
        result.yx = yx;
        result.zx = zx;
        result.xy = xy;
        result.yy = yy;
        result.zy = zy;
        result.xz = xz;
        result.yz = yz;
        result.zz = zz;
        result.xd = xd;
        result.yd = yd;
        result.zd = zd;
    }

    public Transformation3D copy() {
        Transformation3D result = new Transformation3D();
        result.xx = this.xx;
        result.yx = this.yx;
        result.zx = this.zx;
        result.xy = this.xy;
        result.yy = this.yy;
        result.zy = this.zy;
        result.xz = this.xz;
        result.yz = this.yz;
        result.zz = this.zz;
        result.xd = this.xd;
        result.yd = this.yd;
        result.zd = this.zd;
        return result;
    }
}

