/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.net.AbstractSocketAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logback.ExportGroupConfig;
import com.linecorp.armeria.common.logback.LoggingEventWrapper;
import com.linecorp.armeria.common.logback.UnionMap;
import com.linecorp.armeria.common.logging.BuiltInProperty;
import com.linecorp.armeria.common.logging.RequestContextExporter;
import com.linecorp.armeria.common.logging.RequestContextExporterBuilder;
import com.linecorp.armeria.internal.common.FlagsLoaded;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class RequestContextExportingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final Splitter KEY_SPLITTER;
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final RequestContextExporterBuilder builder = RequestContextExporter.builder();
    @Nullable
    private RequestContextExporter exporter;
    private boolean needsHashMap;

    @VisibleForTesting
    RequestContextExporter exporter() {
        Preconditions.checkState((this.exporter != null ? 1 : 0) != 0);
        return this.exporter;
    }

    public void addBuiltIn(BuiltInProperty property) {
        this.ensureNotStarted();
        this.builder.builtIn(property);
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey) {
        this.ensureNotStarted();
        this.builder.attr(alias, attrKey);
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        this.ensureNotStarted();
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        Objects.requireNonNull(stringifier, "stringifier");
        this.builder.attr(alias, attrKey, stringifier);
    }

    public void addRequestHeader(CharSequence name) {
        this.ensureNotStarted();
        Objects.requireNonNull(name, "name");
        this.builder.requestHeader(name);
    }

    public void addResponseHeader(CharSequence name) {
        this.ensureNotStarted();
        Objects.requireNonNull(name, "name");
        this.builder.responseHeader(name);
    }

    public void setPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"prefix must not be empty");
        this.builder.prefix(prefix);
    }

    public void setExport(String mdcKey) {
        Objects.requireNonNull(mdcKey, "mdcKey");
        Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"mdcKey must not be empty");
        this.builder.keyPattern(mdcKey);
    }

    public void setExports(String mdcKeys) {
        Objects.requireNonNull(mdcKeys, "mdcKeys");
        Preconditions.checkArgument((!mdcKeys.isEmpty() ? 1 : 0) != 0, (Object)"mdcKeys must not be empty");
        KEY_SPLITTER.split((CharSequence)mdcKeys).forEach(mdcKey -> {
            Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"comma-separated MDC key must not be empty");
            this.builder.keyPattern(mdcKey);
        });
    }

    public void setExportGroup(ExportGroupConfig exportGroupConfiguration) {
        Objects.requireNonNull(exportGroupConfiguration, "exportGroupConfiguration");
        this.builder.exportGroup(exportGroupConfiguration.build());
    }

    private void ensureNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("can't update the export list once started");
        }
    }

    protected void append(ILoggingEvent eventObject) {
        Map contextMap;
        if (this.exporter == null) {
            if (!FlagsLoaded.get()) {
                this.aai.appendLoopOnAppenders(eventObject);
                return;
            }
            this.exporter = this.builder.build();
        }
        if (!(contextMap = this.exporter.export()).isEmpty()) {
            Map originalMdcMap = eventObject.getMDCPropertyMap();
            Map<String, String> mdcMap = this.prepareMdcMap(contextMap, originalMdcMap);
            eventObject = new LoggingEventWrapper((ILoggingEvent)eventObject, mdcMap);
        }
        this.aai.appendLoopOnAppenders(eventObject);
    }

    private Map<String, String> prepareMdcMap(Map<String, String> contextMap, Map<String, String> originalMdcMap) {
        if (this.needsHashMap) {
            HashMap<String, String> mdcMap = new HashMap<String, String>(contextMap);
            mdcMap.putAll(originalMdcMap);
            return mdcMap;
        }
        if (!originalMdcMap.isEmpty()) {
            return new UnionMap<String, String>(contextMap, originalMdcMap);
        }
        return contextMap;
    }

    public void start() {
        if (!this.aai.iteratorForAppenders().hasNext()) {
            this.addWarn("No appender was attached to " + ((Object)((Object)this)).getClass().getSimpleName() + '.');
        }
        super.start();
    }

    public void stop() {
        try {
            this.aai.detachAndStopAllAppenders();
        }
        finally {
            super.stop();
        }
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        this.needsHashMap = this.isSocketAppender(newAppender);
        this.aai.addAppender(newAppender);
    }

    private boolean isSocketAppender(Appender<ILoggingEvent> appender) {
        if (appender instanceof AbstractSocketAppender) {
            return true;
        }
        if (appender instanceof AppenderAttachable) {
            Iterator i = ((AppenderAttachable)appender).iteratorForAppenders();
            while (i.hasNext()) {
                if (!this.isSocketAppender((Appender<ILoggingEvent>)((Appender)i.next()))) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    static {
        if (InternalLoggerFactory.getDefaultFactory() == null) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        }
        KEY_SPLITTER = Splitter.on((char)',').trimResults();
    }
}

