/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.common.logging.ExportGroup;
import com.linecorp.armeria.common.logging.ExportGroupBuilder;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import java.util.Objects;

public final class ExportGroupConfig {
    private static final Splitter KEY_SPLITTER = Splitter.on((char)',').trimResults();
    private final ExportGroupBuilder builder = ExportGroup.builder();

    public void setPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"prefix must not be empty");
        this.builder.prefix(prefix);
    }

    public void setExport(String mdcKey) {
        Objects.requireNonNull(mdcKey, "mdcKey");
        Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"mdcKey must not be empty");
        this.builder.keyPattern(mdcKey);
    }

    public void setExports(String mdcKeys) {
        Objects.requireNonNull(mdcKeys, "mdcKeys");
        Preconditions.checkArgument((!mdcKeys.isEmpty() ? 1 : 0) != 0, (Object)"mdcKeys must not be empty");
        KEY_SPLITTER.split((CharSequence)mdcKeys).forEach(mdcKey -> {
            Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"comma-separated MDC key must not be empty");
            this.builder.keyPattern(mdcKey);
        });
    }

    ExportGroup build() {
        return this.builder.build();
    }
}

