/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.xml;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import java.io.IOException;
import org.dom4j.DocumentException;

public class XMLUtil {
    public static String formatXML(Document document) {
        try {
            return document.formattedString("  ");
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public static String formatXML(String xml) {
        xml = StringUtil.replace((String)xml, (String)"]]><", (String)"[$SPECIAL_CHARACTER$]");
        xml = StringUtil.replace((String)xml, (String)"]]>", (String)"]]]]><![CDATA[>");
        xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"]]><");
        try {
            xml = StringUtil.replace((String)xml, (String)"&#", (String)"[$SPECIAL_CHARACTER$]");
            xml = Dom4jUtil.toString(xml, "  ");
            xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"&#");
            return xml;
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        catch (DocumentException documentException) {
            throw new SystemException((Throwable)documentException);
        }
    }

    public static String stripInvalidChars(String xml) {
        if (Validator.isNull((String)xml)) {
            return xml;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < xml.length(); ++i) {
            int codePoint;
            char c2;
            char c = xml.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                sb.append(c);
            }
            if (!Character.isHighSurrogate(c) || i + 1 >= xml.length() || !Character.isLowSurrogate(c2 = xml.charAt(i + 1)) || (codePoint = Character.toCodePoint(c, c2)) < 65536 || codePoint > 0x10FFFF) continue;
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }
}

