/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal.manager;

import com.liferay.analytics.batch.exportimport.manager.AnalyticsBatchExportImportManager;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnalyticsBatchExportImportManager.class})
public class AnalyticsBatchExportImportManagerImpl
implements AnalyticsBatchExportImportManager {
    @Reference
    protected BatchEngineExportTaskExecutor batchEngineExportTaskExecutor;
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsBatchExportImportManagerImpl.class);
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss zzz");
    @Reference
    private AnalyticsConfigurationTracker _analyticsConfigurationTracker;
    @Reference
    private AnalyticsMessageLocalService _analyticsMessageLocalService;
    @Reference
    private BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;

    public void exportToAnalyticsCloud(String batchEngineExportTaskItemDelegateName, long companyId, List<String> fieldNamesList, UnsafeConsumer<String, Exception> notificationUnsafeConsumer, Date resourceLastModifiedDate, String resourceName, long userId) throws Exception {
        this._notify("Exporting resource " + resourceName, notificationUnsafeConsumer);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (resourceLastModifiedDate != null) {
            parameters.put("filter", StringBundler.concat((Object[])new Object[]{Field.getSortableFieldName((String)"modified"), " ge ", resourceLastModifiedDate.getTime()}));
        }
        BatchEngineExportTask batchEngineExportTask = this._batchEngineExportTaskLocalService.addBatchEngineExportTask(companyId, userId, null, resourceName, BatchEngineTaskContentType.JSONL.name(), BatchEngineTaskExecuteStatus.INITIAL.name(), fieldNamesList, parameters, batchEngineExportTaskItemDelegateName);
        this._batchEngineExportTaskExecutor.execute(batchEngineExportTask);
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus.equals((Object)BatchEngineTaskExecuteStatus.COMPLETED)) {
            this._notify(StringBundler.concat((Object[])new Object[]{"Exported ", batchEngineExportTask.getTotalItemsCount(), " items for resource ", resourceName}), notificationUnsafeConsumer);
            if (batchEngineExportTask.getTotalItemsCount() == 0) {
                this._notify("There are no items to upload", notificationUnsafeConsumer);
                return;
            }
        } else {
            throw new PortalException("Unable to export resource " + resourceName);
        }
        this._notify("Uploading resource " + resourceName, notificationUnsafeConsumer);
        InputStream contentInputStream = this._batchEngineExportTaskLocalService.openContentInputStream(batchEngineExportTask.getBatchEngineExportTaskId());
        this._upload(companyId, contentInputStream, resourceLastModifiedDate, resourceName);
        contentInputStream.close();
        this._batchEngineExportTaskLocalService.deleteBatchEngineExportTask(batchEngineExportTask);
        this._notify("Completed uploading resource " + resourceName, notificationUnsafeConsumer);
    }

    public void importFromAnalyticsCloud(String batchEngineImportTaskItemDelegateName, long companyId, Map<String, String> fieldMapping, UnsafeConsumer<String, Exception> notificationUnsafeConsumer, Date resourceLastModifiedDate, String resourceName, long userId) throws Exception {
        this._notify("Checking modifications for resource " + resourceName, notificationUnsafeConsumer);
        File resourceFile = this._download(companyId, resourceLastModifiedDate, resourceName);
        if (resourceFile == null) {
            this._notify("There are no modifications for resource " + resourceName, notificationUnsafeConsumer);
            return;
        }
        this._notify("Importing resource " + resourceName, notificationUnsafeConsumer);
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(companyId, userId, 50L, null, resourceName, Files.readAllBytes(resourceFile.toPath()), BatchEngineTaskContentType.JSONL.name(), BatchEngineTaskExecuteStatus.INITIAL.name(), fieldMapping, BatchEngineTaskOperation.CREATE.name(), null, batchEngineImportTaskItemDelegateName);
        this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (!batchEngineTaskExecuteStatus.equals((Object)BatchEngineTaskExecuteStatus.COMPLETED)) {
            throw new PortalException("Unable to import resource " + resourceName);
        }
        this._notify(StringBundler.concat((Object[])new Object[]{"Imported ", batchEngineImportTask.getTotalItemsCount(), " items for resource ", resourceName}), notificationUnsafeConsumer);
        this._batchEngineImportTaskLocalService.deleteBatchEngineImportTask(batchEngineImportTask);
    }

    private void _checkCompany(long companyId) {
        AnalyticsConfiguration analyticsConfiguration;
        if (this._analyticsConfigurationTracker.isActive()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Analytics configuration tracker is inactive");
        }
        if (Validator.isNotNull((String)(analyticsConfiguration = this._analyticsConfigurationTracker.getAnalyticsConfiguration(companyId)).liferayAnalyticsEndpointURL())) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Analytics configuration endpoint URL is null");
        }
        throw new IllegalStateException("Analytics batch export/import is disabled");
    }

    private File _download(long companyId, Date resourceLastModifiedDate, String resourceName) {
        this._checkCompany(companyId);
        Http.Options options = this._getOptions(companyId);
        if (resourceLastModifiedDate != null) {
            options.addHeader("If-Modified-Since", _format.format(resourceLastModifiedDate));
        }
        AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        options.setLocation(this._http.addParameter(analyticsConfiguration.liferayAnalyticsEndpointURL() + "/dxp-batch-entities", "resourceName", resourceName));
        try {
            InputStream inputStream = this._http.URLtoInputStream(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 403) {
                JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)inputStream));
                this._processInvalidTokenMessage(companyId, responseJSONObject.getString("message"));
            }
            if (inputStream != null) {
                return FileUtil.createTempFile((InputStream)inputStream);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private Http.Options _getOptions(long companyId) {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        Http.Options options = new Http.Options();
        options.addHeader("OSB-Asah-Data-Source-ID", analyticsConfiguration.liferayAnalyticsDataSourceId());
        options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature());
        options.addHeader("OSB-Asah-Project-ID", analyticsConfiguration.liferayAnalyticsProjectId());
        return options;
    }

    private void _notify(String message, UnsafeConsumer<String, Exception> notificationUnsafeConsumer) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)message);
        }
        if (notificationUnsafeConsumer == null) {
            return;
        }
        notificationUnsafeConsumer.accept((Object)message);
    }

    private void _processInvalidTokenMessage(long companyId, String message) {
        block8: {
            block7: {
                if (!Objects.equals(message, "INVALID_TOKEN")) {
                    return;
                }
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Disconnecting data source for company ", companyId, ": ", message}));
                }
                try {
                    this._companyLocalService.updatePreferences(companyId, UnicodePropertiesBuilder.create((boolean)true).put("liferayAnalyticsConnectionType", "").put("liferayAnalyticsDataSourceId", "").put("liferayAnalyticsEndpointURL", "").put("liferayAnalyticsFaroBackendSecuritySignature", "").put("liferayAnalyticsFaroBackendURL", "").put("liferayAnalyticsGroupIds", "").put("liferayAnalyticsProjectId", "").put("liferayAnalyticsURL", "").build());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)("Unable to remove analytics preferences for company " + companyId), (Throwable)exception);
                }
            }
            try {
                this._configurationProvider.deleteCompanyConfiguration(AnalyticsConfiguration.class, companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to remove analytics configuration for company " + companyId), (Throwable)exception);
            }
        }
        this._analyticsMessageLocalService.deleteAnalyticsMessages(companyId);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deleted all analytics messages for company " + companyId));
        }
    }

    private void _upload(long companyId, InputStream resourceInputStream, Date resourceLastModifiedDate, String resourceName) {
        this._checkCompany(companyId);
        Http.Options options = this._getOptions(companyId);
        options.addHeader("Content-Type", "multipart/form-data; boundary=__MULTIPART_BOUNDARY__");
        options.addInputStreamPart("file", resourceName, resourceInputStream, "multipart/form-data");
        options.addPart("uploadType", resourceLastModifiedDate != null ? "INCREMENTAL" : "FULL");
        AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        options.setLocation(analyticsConfiguration.liferayAnalyticsEndpointURL() + "/dxp-batch-entities");
        options.setPost(true);
        try {
            InputStream inputStream = this._http.URLtoInputStream(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 403) {
                JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)inputStream));
                this._processInvalidTokenMessage(companyId, responseJSONObject.getString("message"));
            }
            if (response.getResponseCode() < 200 || response.getResponseCode() >= 300) {
                throw new Exception("Upload failed with HTTP response code: " + response.getResponseCode());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Upload completed successfully");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

