/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public class JMeterConfigurationHolder {
    private static final JMeterConfigurationHolder INSTANCE = new JMeterConfigurationHolder();
    private String runtimeJarName;
    private File workingDirectory;
    private Map<ConfigurationFiles, PropertiesMapping> propertiesMap;
    private boolean configurationFreezed;

    private JMeterConfigurationHolder() {
    }

    public static final JMeterConfigurationHolder getInstance() {
        return INSTANCE;
    }

    public String getRuntimeJarName() {
        return this.runtimeJarName;
    }

    void setRuntimeJarName(String runtimeJarName) {
        if (this.configurationFreezed) {
            throw new IllegalStateException("setRuntimeJarName called while JMeter configuration already freezed");
        }
        this.runtimeJarName = runtimeJarName;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    void setWorkingDirectory(File workingDirectory) {
        if (this.configurationFreezed) {
            throw new IllegalStateException("setWorkingDirectory called while JMeter configuration already freezed");
        }
        this.workingDirectory = workingDirectory;
    }

    public Map<ConfigurationFiles, PropertiesMapping> getPropertiesMap() {
        return this.propertiesMap;
    }

    void setPropertiesMap(Map<ConfigurationFiles, PropertiesMapping> propertiesMap) {
        if (this.configurationFreezed) {
            throw new IllegalStateException("setPropertiesMap called while JMeter configuration already freezed");
        }
        this.propertiesMap = Collections.unmodifiableMap(propertiesMap);
    }

    void freezeConfiguration() {
        this.configurationFreezed = true;
    }

    void resetConfiguration() {
        this.workingDirectory = null;
        this.runtimeJarName = null;
        this.propertiesMap = null;
        this.configurationFreezed = false;
    }
}

