/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.utils.pagination.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MetaResponse {
    private final int page;
    private final int limit;
    private final int totalItems;
    private final int totalPages;
    private final Map<String, Object> additionalProperties;

    private MetaResponse(int page, int limit, int totalItems, int totalPages, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.totalItems = totalItems;
        this.totalPages = totalPages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public int getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="totalItems")
    public int getTotalItems() {
        return this.totalItems;
    }

    @JsonProperty(value="totalPages")
    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetaResponse && this.equalTo((MetaResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetaResponse other) {
        return this.page == other.page && this.limit == other.limit && this.totalItems == other.totalItems && this.totalPages == other.totalPages;
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.totalItems, this.totalPages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PageStage,
    LimitStage,
    TotalItemsStage,
    TotalPagesStage,
    _FinalStage {
        private int page;
        private int limit;
        private int totalItems;
        private int totalPages;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MetaResponse other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.totalItems(other.getTotalItems());
            this.totalPages(other.getTotalPages());
            return this;
        }

        @Override
        @JsonSetter(value="page")
        public LimitStage page(int page) {
            this.page = page;
            return this;
        }

        @Override
        @JsonSetter(value="limit")
        public TotalItemsStage limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        @JsonSetter(value="totalItems")
        public TotalPagesStage totalItems(int totalItems) {
            this.totalItems = totalItems;
            return this;
        }

        @Override
        @JsonSetter(value="totalPages")
        public _FinalStage totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        @Override
        public MetaResponse build() {
            return new MetaResponse(this.page, this.limit, this.totalItems, this.totalPages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MetaResponse build();
    }

    public static interface TotalPagesStage {
        public _FinalStage totalPages(int var1);
    }

    public static interface TotalItemsStage {
        public TotalPagesStage totalItems(int var1);
    }

    public static interface LimitStage {
        public TotalItemsStage limit(int var1);
    }

    public static interface PageStage {
        public LimitStage page(int var1);

        public Builder from(MetaResponse var1);
    }
}

