/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.LangfuseClientApiException;
import com.langfuse.client.core.LangfuseClientException;
import com.langfuse.client.core.MediaTypes;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.core.QueryStringMapper;
import com.langfuse.client.core.RequestOptions;
import com.langfuse.client.resources.commons.errors.AccessDeniedError;
import com.langfuse.client.resources.commons.errors.Error;
import com.langfuse.client.resources.commons.errors.MethodNotAllowedError;
import com.langfuse.client.resources.commons.errors.NotFoundError;
import com.langfuse.client.resources.commons.errors.UnauthorizedError;
import com.langfuse.client.resources.commons.types.TraceWithFullDetails;
import com.langfuse.client.resources.trace.requests.DeleteTracesRequest;
import com.langfuse.client.resources.trace.requests.GetTracesRequest;
import com.langfuse.client.resources.trace.types.DeleteTraceResponse;
import com.langfuse.client.resources.trace.types.Traces;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TraceClient {
    protected final ClientOptions clientOptions;

    public TraceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public TraceWithFullDetails get(String traceId) {
        return this.get(traceId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TraceWithFullDetails get(String traceId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("traces").addPathSegment(traceId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                TraceWithFullDetails traceWithFullDetails = (TraceWithFullDetails)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), TraceWithFullDetails.class);
                return traceWithFullDetails;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public DeleteTraceResponse delete(String traceId) {
        return this.delete(traceId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteTraceResponse delete(String traceId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("traces").addPathSegment(traceId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DeleteTraceResponse deleteTraceResponse = (DeleteTraceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteTraceResponse.class);
                return deleteTraceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public Traces list() {
        return this.list(GetTracesRequest.builder().build());
    }

    public Traces list(GetTracesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Traces list(GetTracesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("traces");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get().toString(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get().toString(), false);
        }
        if (request.getUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "userId", request.getUserId().get(), false);
        }
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getSessionId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sessionId", request.getSessionId().get(), false);
        }
        if (request.getFromTimestamp().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "fromTimestamp", request.getFromTimestamp().get().toString(), false);
        }
        if (request.getToTimestamp().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "toTimestamp", request.getToTimestamp().get().toString(), false);
        }
        if (request.getOrderBy().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "orderBy", request.getOrderBy().get(), false);
        }
        if (request.getTags().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "tags", request.getTags().get(), false);
        }
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        if (request.getRelease().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "release", request.getRelease().get(), false);
        }
        if (request.getEnvironment().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "environment", request.getEnvironment().get(), false);
        }
        if (request.getFields().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "fields", request.getFields().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Traces traces = (Traces)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Traces.class);
                return traces;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public DeleteTraceResponse deleteMultiple(DeleteTracesRequest request) {
        return this.deleteMultiple(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteTraceResponse deleteMultiple(DeleteTracesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("traces").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new LangfuseClientException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DeleteTraceResponse deleteTraceResponse = (DeleteTraceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteTraceResponse.class);
                return deleteTraceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }
}

