/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserMeta {
    private final String resourceType;
    private final Optional<String> created;
    private final Optional<String> lastModified;
    private final Map<String, Object> additionalProperties;

    private UserMeta(String resourceType, Optional<String> created, Optional<String> lastModified, Map<String, Object> additionalProperties) {
        this.resourceType = resourceType;
        this.created = created;
        this.lastModified = lastModified;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="created")
    public Optional<String> getCreated() {
        return this.created;
    }

    @JsonProperty(value="lastModified")
    public Optional<String> getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserMeta && this.equalTo((UserMeta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserMeta other) {
        return this.resourceType.equals(other.resourceType) && this.created.equals(other.created) && this.lastModified.equals(other.lastModified);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.created, this.lastModified);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResourceTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ResourceTypeStage,
    _FinalStage {
        private String resourceType;
        private Optional<String> lastModified = Optional.empty();
        private Optional<String> created = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UserMeta other) {
            this.resourceType(other.getResourceType());
            this.created(other.getCreated());
            this.lastModified(other.getLastModified());
            return this;
        }

        @Override
        @JsonSetter(value="resourceType")
        public _FinalStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @Override
        public _FinalStage lastModified(String lastModified) {
            this.lastModified = Optional.ofNullable(lastModified);
            return this;
        }

        @Override
        @JsonSetter(value="lastModified", nulls=Nulls.SKIP)
        public _FinalStage lastModified(Optional<String> lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public _FinalStage created(String created) {
            this.created = Optional.ofNullable(created);
            return this;
        }

        @Override
        @JsonSetter(value="created", nulls=Nulls.SKIP)
        public _FinalStage created(Optional<String> created) {
            this.created = created;
            return this;
        }

        @Override
        public UserMeta build() {
            return new UserMeta(this.resourceType, this.created, this.lastModified, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UserMeta build();

        public _FinalStage created(Optional<String> var1);

        public _FinalStage created(String var1);

        public _FinalStage lastModified(Optional<String> var1);

        public _FinalStage lastModified(String var1);
    }

    public static interface ResourceTypeStage {
        public _FinalStage resourceType(@NotNull String var1);

        public Builder from(UserMeta var1);
    }
}

