/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ResourceMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SchemaResource {
    private final String id;
    private final String name;
    private final String description;
    private final List<Object> attributes;
    private final ResourceMeta meta;
    private final Map<String, Object> additionalProperties;

    private SchemaResource(String id, String name, String description, List<Object> attributes, ResourceMeta meta, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.attributes = attributes;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="attributes")
    public List<Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="meta")
    public ResourceMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SchemaResource && this.equalTo((SchemaResource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SchemaResource other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.description.equals(other.description) && this.attributes.equals(other.attributes) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.attributes, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    DescriptionStage,
    MetaStage,
    _FinalStage {
        private String id;
        private String name;
        private String description;
        private ResourceMeta meta;
        private List<Object> attributes = new ArrayList<Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SchemaResource other) {
            this.id(other.getId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.attributes(other.getAttributes());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public MetaStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="meta")
        public _FinalStage meta(@NotNull ResourceMeta meta) {
            this.meta = Objects.requireNonNull(meta, "meta must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllAttributes(List<Object> attributes) {
            this.attributes.addAll(attributes);
            return this;
        }

        @Override
        public _FinalStage addAttributes(Object attributes) {
            this.attributes.add(attributes);
            return this;
        }

        @Override
        @JsonSetter(value="attributes", nulls=Nulls.SKIP)
        public _FinalStage attributes(List<Object> attributes) {
            this.attributes.clear();
            this.attributes.addAll(attributes);
            return this;
        }

        @Override
        public SchemaResource build() {
            return new SchemaResource(this.id, this.name, this.description, this.attributes, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SchemaResource build();

        public _FinalStage attributes(List<Object> var1);

        public _FinalStage addAttributes(Object var1);

        public _FinalStage addAllAttributes(List<Object> var1);
    }

    public static interface MetaStage {
        public _FinalStage meta(@NotNull ResourceMeta var1);
    }

    public static interface DescriptionStage {
        public MetaStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(SchemaResource var1);
    }
}

