/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApiKeySummary {
    private final String id;
    private final OffsetDateTime createdAt;
    private final Optional<OffsetDateTime> expiresAt;
    private final Optional<OffsetDateTime> lastUsedAt;
    private final Optional<String> note;
    private final String publicKey;
    private final String displaySecretKey;
    private final Map<String, Object> additionalProperties;

    private ApiKeySummary(String id, OffsetDateTime createdAt, Optional<OffsetDateTime> expiresAt, Optional<OffsetDateTime> lastUsedAt, Optional<String> note, String publicKey, String displaySecretKey, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.lastUsedAt = lastUsedAt;
        this.note = note;
        this.publicKey = publicKey;
        this.displaySecretKey = displaySecretKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="expiresAt")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="lastUsedAt")
    public Optional<OffsetDateTime> getLastUsedAt() {
        return this.lastUsedAt;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    @JsonProperty(value="publicKey")
    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="displaySecretKey")
    public String getDisplaySecretKey() {
        return this.displaySecretKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiKeySummary && this.equalTo((ApiKeySummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiKeySummary other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.expiresAt.equals(other.expiresAt) && this.lastUsedAt.equals(other.lastUsedAt) && this.note.equals(other.note) && this.publicKey.equals(other.publicKey) && this.displaySecretKey.equals(other.displaySecretKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.expiresAt, this.lastUsedAt, this.note, this.publicKey, this.displaySecretKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    PublicKeyStage,
    DisplaySecretKeyStage,
    _FinalStage {
        private String id;
        private OffsetDateTime createdAt;
        private String publicKey;
        private String displaySecretKey;
        private Optional<String> note = Optional.empty();
        private Optional<OffsetDateTime> lastUsedAt = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ApiKeySummary other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.expiresAt(other.getExpiresAt());
            this.lastUsedAt(other.getLastUsedAt());
            this.note(other.getNote());
            this.publicKey(other.getPublicKey());
            this.displaySecretKey(other.getDisplaySecretKey());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public PublicKeyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="publicKey")
        public DisplaySecretKeyStage publicKey(@NotNull String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="displaySecretKey")
        public _FinalStage displaySecretKey(@NotNull String displaySecretKey) {
            this.displaySecretKey = Objects.requireNonNull(displaySecretKey, "displaySecretKey must not be null");
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage lastUsedAt(OffsetDateTime lastUsedAt) {
            this.lastUsedAt = Optional.ofNullable(lastUsedAt);
            return this;
        }

        @Override
        @JsonSetter(value="lastUsedAt", nulls=Nulls.SKIP)
        public _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        @Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        @JsonSetter(value="expiresAt", nulls=Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public ApiKeySummary build() {
            return new ApiKeySummary(this.id, this.createdAt, this.expiresAt, this.lastUsedAt, this.note, this.publicKey, this.displaySecretKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ApiKeySummary build();

        public _FinalStage expiresAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiresAt(OffsetDateTime var1);

        public _FinalStage lastUsedAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastUsedAt(OffsetDateTime var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);
    }

    public static interface DisplaySecretKeyStage {
        public _FinalStage displaySecretKey(@NotNull String var1);
    }

    public static interface PublicKeyStage {
        public DisplaySecretKeyStage publicKey(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public PublicKeyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);

        public Builder from(ApiKeySummary var1);
    }
}

