/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TraceBody {
    private final Optional<String> id;
    private final Optional<OffsetDateTime> timestamp;
    private final Optional<String> name;
    private final Optional<String> userId;
    private final Optional<Object> input;
    private final Optional<Object> output;
    private final Optional<String> sessionId;
    private final Optional<String> release;
    private final Optional<String> version;
    private final Optional<Object> metadata;
    private final Optional<List<String>> tags;
    private final Optional<String> environment;
    private final Optional<Boolean> public_;
    private final Map<String, Object> additionalProperties;

    private TraceBody(Optional<String> id, Optional<OffsetDateTime> timestamp, Optional<String> name, Optional<String> userId, Optional<Object> input, Optional<Object> output, Optional<String> sessionId, Optional<String> release, Optional<String> version, Optional<Object> metadata, Optional<List<String>> tags, Optional<String> environment, Optional<Boolean> public_, Map<String, Object> additionalProperties) {
        this.id = id;
        this.timestamp = timestamp;
        this.name = name;
        this.userId = userId;
        this.input = input;
        this.output = output;
        this.sessionId = sessionId;
        this.release = release;
        this.version = version;
        this.metadata = metadata;
        this.tags = tags;
        this.environment = environment;
        this.public_ = public_;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="timestamp")
    public Optional<OffsetDateTime> getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="userId")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @JsonProperty(value="output")
    public Optional<Object> getOutput() {
        return this.output;
    }

    @JsonProperty(value="sessionId")
    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="release")
    public Optional<String> getRelease() {
        return this.release;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="tags")
    public Optional<List<String>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="public")
    public Optional<Boolean> getPublic() {
        return this.public_;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TraceBody && this.equalTo((TraceBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TraceBody other) {
        return this.id.equals(other.id) && this.timestamp.equals(other.timestamp) && this.name.equals(other.name) && this.userId.equals(other.userId) && this.input.equals(other.input) && this.output.equals(other.output) && this.sessionId.equals(other.sessionId) && this.release.equals(other.release) && this.version.equals(other.version) && this.metadata.equals(other.metadata) && this.tags.equals(other.tags) && this.environment.equals(other.environment) && this.public_.equals(other.public_);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timestamp, this.name, this.userId, this.input, this.output, this.sessionId, this.release, this.version, this.metadata, this.tags, this.environment, this.public_);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<OffsetDateTime> timestamp = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<Object> input = Optional.empty();
        private Optional<Object> output = Optional.empty();
        private Optional<String> sessionId = Optional.empty();
        private Optional<String> release = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<List<String>> tags = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<Boolean> public_ = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TraceBody other) {
            this.id(other.getId());
            this.timestamp(other.getTimestamp());
            this.name(other.getName());
            this.userId(other.getUserId());
            this.input(other.getInput());
            this.output(other.getOutput());
            this.sessionId(other.getSessionId());
            this.release(other.getRelease());
            this.version(other.getVersion());
            this.metadata(other.getMetadata());
            this.tags(other.getTags());
            this.environment(other.getEnvironment());
            this.public_(other.getPublic());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="timestamp", nulls=Nulls.SKIP)
        public Builder timestamp(Optional<OffsetDateTime> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="userId", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public Builder input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        public Builder input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public Builder output(Optional<Object> output) {
            this.output = output;
            return this;
        }

        public Builder output(Object output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @JsonSetter(value="sessionId", nulls=Nulls.SKIP)
        public Builder sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @JsonSetter(value="release", nulls=Nulls.SKIP)
        public Builder release(Optional<String> release) {
            this.release = release;
            return this;
        }

        public Builder release(String release) {
            this.release = Optional.ofNullable(release);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<List<String>> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @JsonSetter(value="public", nulls=Nulls.SKIP)
        public Builder public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        public Builder public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        public TraceBody build() {
            return new TraceBody(this.id, this.timestamp, this.name, this.userId, this.input, this.output, this.sessionId, this.release, this.version, this.metadata, this.tags, this.environment, this.public_, this.additionalProperties);
        }
    }
}

