/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.Usage;
import com.langfuse.client.resources.ingestion.types.OpenAiUsage;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class IngestionUsage {
    private final Object value;
    private final int type;

    private IngestionUsage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Usage)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((OpenAiUsage)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IngestionUsage && this.equalTo((IngestionUsage)other);
    }

    private boolean equalTo(IngestionUsage other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static IngestionUsage of(Usage value) {
        return new IngestionUsage(value, 0);
    }

    public static IngestionUsage of(OpenAiUsage value) {
        return new IngestionUsage(value, 1);
    }

    public static interface Visitor<T> {
        public T visit(Usage var1);

        public T visit(OpenAiUsage var1);
    }

    static final class Deserializer
    extends StdDeserializer<IngestionUsage> {
        Deserializer() {
            super(IngestionUsage.class);
        }

        public IngestionUsage deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return IngestionUsage.of((Usage)ObjectMappers.JSON_MAPPER.convertValue(value, Usage.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return IngestionUsage.of((OpenAiUsage)ObjectMappers.JSON_MAPPER.convertValue(value, OpenAiUsage.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }
}

