/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.langfuse.client.resources.ingestion.types.CreateEventEvent;
import com.langfuse.client.resources.ingestion.types.CreateGenerationEvent;
import com.langfuse.client.resources.ingestion.types.CreateObservationEvent;
import com.langfuse.client.resources.ingestion.types.CreateSpanEvent;
import com.langfuse.client.resources.ingestion.types.ScoreEvent;
import com.langfuse.client.resources.ingestion.types.SdkLogEvent;
import com.langfuse.client.resources.ingestion.types.TraceEvent;
import com.langfuse.client.resources.ingestion.types.UpdateGenerationEvent;
import com.langfuse.client.resources.ingestion.types.UpdateObservationEvent;
import com.langfuse.client.resources.ingestion.types.UpdateSpanEvent;
import java.util.Objects;
import java.util.Optional;

public final class IngestionEvent {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private IngestionEvent(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static IngestionEvent traceCreate(TraceEvent value) {
        return new IngestionEvent(new TraceCreateValue(value));
    }

    public static IngestionEvent scoreCreate(ScoreEvent value) {
        return new IngestionEvent(new ScoreCreateValue(value));
    }

    public static IngestionEvent spanCreate(CreateSpanEvent value) {
        return new IngestionEvent(new SpanCreateValue(value));
    }

    public static IngestionEvent spanUpdate(UpdateSpanEvent value) {
        return new IngestionEvent(new SpanUpdateValue(value));
    }

    public static IngestionEvent generationCreate(CreateGenerationEvent value) {
        return new IngestionEvent(new GenerationCreateValue(value));
    }

    public static IngestionEvent generationUpdate(UpdateGenerationEvent value) {
        return new IngestionEvent(new GenerationUpdateValue(value));
    }

    public static IngestionEvent eventCreate(CreateEventEvent value) {
        return new IngestionEvent(new EventCreateValue(value));
    }

    public static IngestionEvent sdkLog(SdkLogEvent value) {
        return new IngestionEvent(new SdkLogValue(value));
    }

    public static IngestionEvent observationCreate(CreateObservationEvent value) {
        return new IngestionEvent(new ObservationCreateValue(value));
    }

    public static IngestionEvent observationUpdate(UpdateObservationEvent value) {
        return new IngestionEvent(new ObservationUpdateValue(value));
    }

    public boolean isTraceCreate() {
        return this.value instanceof TraceCreateValue;
    }

    public boolean isScoreCreate() {
        return this.value instanceof ScoreCreateValue;
    }

    public boolean isSpanCreate() {
        return this.value instanceof SpanCreateValue;
    }

    public boolean isSpanUpdate() {
        return this.value instanceof SpanUpdateValue;
    }

    public boolean isGenerationCreate() {
        return this.value instanceof GenerationCreateValue;
    }

    public boolean isGenerationUpdate() {
        return this.value instanceof GenerationUpdateValue;
    }

    public boolean isEventCreate() {
        return this.value instanceof EventCreateValue;
    }

    public boolean isSdkLog() {
        return this.value instanceof SdkLogValue;
    }

    public boolean isObservationCreate() {
        return this.value instanceof ObservationCreateValue;
    }

    public boolean isObservationUpdate() {
        return this.value instanceof ObservationUpdateValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<TraceEvent> getTraceCreate() {
        if (this.isTraceCreate()) {
            return Optional.of(((TraceCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ScoreEvent> getScoreCreate() {
        if (this.isScoreCreate()) {
            return Optional.of(((ScoreCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CreateSpanEvent> getSpanCreate() {
        if (this.isSpanCreate()) {
            return Optional.of(((SpanCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<UpdateSpanEvent> getSpanUpdate() {
        if (this.isSpanUpdate()) {
            return Optional.of(((SpanUpdateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CreateGenerationEvent> getGenerationCreate() {
        if (this.isGenerationCreate()) {
            return Optional.of(((GenerationCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<UpdateGenerationEvent> getGenerationUpdate() {
        if (this.isGenerationUpdate()) {
            return Optional.of(((GenerationUpdateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CreateEventEvent> getEventCreate() {
        if (this.isEventCreate()) {
            return Optional.of(((EventCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SdkLogEvent> getSdkLog() {
        if (this.isSdkLog()) {
            return Optional.of(((SdkLogValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CreateObservationEvent> getObservationCreate() {
        if (this.isObservationCreate()) {
            return Optional.of(((ObservationCreateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<UpdateObservationEvent> getObservationUpdate() {
        if (this.isObservationUpdate()) {
            return Optional.of(((ObservationUpdateValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TraceCreateValue.class), @JsonSubTypes.Type(value=ScoreCreateValue.class), @JsonSubTypes.Type(value=SpanCreateValue.class), @JsonSubTypes.Type(value=SpanUpdateValue.class), @JsonSubTypes.Type(value=GenerationCreateValue.class), @JsonSubTypes.Type(value=GenerationUpdateValue.class), @JsonSubTypes.Type(value=EventCreateValue.class), @JsonSubTypes.Type(value=SdkLogValue.class), @JsonSubTypes.Type(value=ObservationCreateValue.class), @JsonSubTypes.Type(value=ObservationUpdateValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitTraceCreate(TraceEvent var1);

        public T visitScoreCreate(ScoreEvent var1);

        public T visitSpanCreate(CreateSpanEvent var1);

        public T visitSpanUpdate(UpdateSpanEvent var1);

        public T visitGenerationCreate(CreateGenerationEvent var1);

        public T visitGenerationUpdate(UpdateGenerationEvent var1);

        public T visitEventCreate(CreateEventEvent var1);

        public T visitSdkLog(SdkLogEvent var1);

        public T visitObservationCreate(CreateObservationEvent var1);

        public T visitObservationUpdate(UpdateObservationEvent var1);

        public T _visitUnknown(Object var1);
    }

    @JsonTypeName(value="trace-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class TraceCreateValue
    implements Value {
        @JsonUnwrapped
        private TraceEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TraceCreateValue() {
        }

        private TraceCreateValue(TraceEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTraceCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TraceCreateValue && this.equalTo((TraceCreateValue)other);
        }

        private boolean equalTo(TraceCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="score-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class ScoreCreateValue
    implements Value {
        @JsonUnwrapped
        private ScoreEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ScoreCreateValue() {
        }

        private ScoreCreateValue(ScoreEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitScoreCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ScoreCreateValue && this.equalTo((ScoreCreateValue)other);
        }

        private boolean equalTo(ScoreCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="span-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class SpanCreateValue
    implements Value {
        @JsonUnwrapped
        private CreateSpanEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SpanCreateValue() {
        }

        private SpanCreateValue(CreateSpanEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSpanCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SpanCreateValue && this.equalTo((SpanCreateValue)other);
        }

        private boolean equalTo(SpanCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="span-update")
    @JsonIgnoreProperties(value={"type"})
    private static final class SpanUpdateValue
    implements Value {
        @JsonUnwrapped
        private UpdateSpanEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SpanUpdateValue() {
        }

        private SpanUpdateValue(UpdateSpanEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSpanUpdate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SpanUpdateValue && this.equalTo((SpanUpdateValue)other);
        }

        private boolean equalTo(SpanUpdateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="generation-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class GenerationCreateValue
    implements Value {
        @JsonUnwrapped
        private CreateGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private GenerationCreateValue() {
        }

        private GenerationCreateValue(CreateGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitGenerationCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof GenerationCreateValue && this.equalTo((GenerationCreateValue)other);
        }

        private boolean equalTo(GenerationCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="generation-update")
    @JsonIgnoreProperties(value={"type"})
    private static final class GenerationUpdateValue
    implements Value {
        @JsonUnwrapped
        private UpdateGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private GenerationUpdateValue() {
        }

        private GenerationUpdateValue(UpdateGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitGenerationUpdate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof GenerationUpdateValue && this.equalTo((GenerationUpdateValue)other);
        }

        private boolean equalTo(GenerationUpdateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="event-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class EventCreateValue
    implements Value {
        @JsonUnwrapped
        private CreateEventEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EventCreateValue() {
        }

        private EventCreateValue(CreateEventEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitEventCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EventCreateValue && this.equalTo((EventCreateValue)other);
        }

        private boolean equalTo(EventCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="sdk-log")
    @JsonIgnoreProperties(value={"type"})
    private static final class SdkLogValue
    implements Value {
        @JsonUnwrapped
        private SdkLogEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SdkLogValue() {
        }

        private SdkLogValue(SdkLogEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSdkLog(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SdkLogValue && this.equalTo((SdkLogValue)other);
        }

        private boolean equalTo(SdkLogValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="observation-create")
    @JsonIgnoreProperties(value={"type"})
    private static final class ObservationCreateValue
    implements Value {
        @JsonUnwrapped
        private CreateObservationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ObservationCreateValue() {
        }

        private ObservationCreateValue(CreateObservationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitObservationCreate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ObservationCreateValue && this.equalTo((ObservationCreateValue)other);
        }

        private boolean equalTo(ObservationCreateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="observation-update")
    @JsonIgnoreProperties(value={"type"})
    private static final class ObservationUpdateValue
    implements Value {
        @JsonUnwrapped
        private UpdateObservationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ObservationUpdateValue() {
        }

        private ObservationUpdateValue(UpdateObservationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitObservationUpdate(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ObservationUpdateValue && this.equalTo((ObservationUpdateValue)other);
        }

        private boolean equalTo(ObservationUpdateValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "IngestionEvent{value: " + this.value + "}";
        }
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "IngestionEvent{type: " + this.type + ", value: " + this.value + "}";
        }
    }
}

