/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.health.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class HealthResponse {
    private final String version;
    private final String status;
    private final Map<String, Object> additionalProperties;

    private HealthResponse(String version, String status, Map<String, Object> additionalProperties) {
        this.version = version;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HealthResponse && this.equalTo((HealthResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HealthResponse other) {
        return this.version.equals(other.version) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VersionStage,
    StatusStage,
    _FinalStage {
        private String version;
        private String status;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(HealthResponse other) {
            this.version(other.getVersion());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public StatusStage version(@NotNull String version) {
            this.version = Objects.requireNonNull(version, "version must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        public HealthResponse build() {
            return new HealthResponse(this.version, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public HealthResponse build();
    }

    public static interface StatusStage {
        public _FinalStage status(@NotNull String var1);
    }

    public static interface VersionStage {
        public StatusStage version(@NotNull String var1);

        public Builder from(HealthResponse var1);
    }
}

