/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.datasetrunitems.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.datasetrunitems.types.PaginatedDatasetRunItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListDatasetRunItemsRequest {
    private final String datasetId;
    private final String runName;
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final PaginatedDatasetRunItems response;
    private final Map<String, Object> additionalProperties;

    private ListDatasetRunItemsRequest(String datasetId, String runName, Optional<Integer> page, Optional<Integer> limit, PaginatedDatasetRunItems response, Map<String, Object> additionalProperties) {
        this.datasetId = datasetId;
        this.runName = runName;
        this.page = page;
        this.limit = limit;
        this.response = response;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="datasetId")
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="runName")
    public String getRunName() {
        return this.runName;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="response")
    public PaginatedDatasetRunItems getResponse() {
        return this.response;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListDatasetRunItemsRequest && this.equalTo((ListDatasetRunItemsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListDatasetRunItemsRequest other) {
        return this.datasetId.equals(other.datasetId) && this.runName.equals(other.runName) && this.page.equals(other.page) && this.limit.equals(other.limit) && this.response.equals(other.response);
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.runName, this.page, this.limit, this.response);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DatasetIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DatasetIdStage,
    RunNameStage,
    ResponseStage,
    _FinalStage {
        private String datasetId;
        private String runName;
        private PaginatedDatasetRunItems response;
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListDatasetRunItemsRequest other) {
            this.datasetId(other.getDatasetId());
            this.runName(other.getRunName());
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.response(other.getResponse());
            return this;
        }

        @Override
        @JsonSetter(value="datasetId")
        public RunNameStage datasetId(@NotNull String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="runName")
        public ResponseStage runName(@NotNull String runName) {
            this.runName = Objects.requireNonNull(runName, "runName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="response")
        public _FinalStage response(@NotNull PaginatedDatasetRunItems response) {
            this.response = Objects.requireNonNull(response, "response must not be null");
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @Override
        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @Override
        public ListDatasetRunItemsRequest build() {
            return new ListDatasetRunItemsRequest(this.datasetId, this.runName, this.page, this.limit, this.response, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListDatasetRunItemsRequest build();

        public _FinalStage page(Optional<Integer> var1);

        public _FinalStage page(Integer var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);
    }

    public static interface ResponseStage {
        public _FinalStage response(@NotNull PaginatedDatasetRunItems var1);
    }

    public static interface RunNameStage {
        public ResponseStage runName(@NotNull String var1);
    }

    public static interface DatasetIdStage {
        public RunNameStage datasetId(@NotNull String var1);

        public Builder from(ListDatasetRunItemsRequest var1);
    }
}

