/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DatasetRunItem {
    private final String id;
    private final String datasetRunId;
    private final String datasetRunName;
    private final String datasetItemId;
    private final String traceId;
    private final Optional<String> observationId;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private DatasetRunItem(String id, String datasetRunId, String datasetRunName, String datasetItemId, String traceId, Optional<String> observationId, OffsetDateTime createdAt, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.datasetRunId = datasetRunId;
        this.datasetRunName = datasetRunName;
        this.datasetItemId = datasetItemId;
        this.traceId = traceId;
        this.observationId = observationId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="datasetRunId")
    public String getDatasetRunId() {
        return this.datasetRunId;
    }

    @JsonProperty(value="datasetRunName")
    public String getDatasetRunName() {
        return this.datasetRunName;
    }

    @JsonProperty(value="datasetItemId")
    public String getDatasetItemId() {
        return this.datasetItemId;
    }

    @JsonProperty(value="traceId")
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetRunItem && this.equalTo((DatasetRunItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetRunItem other) {
        return this.id.equals(other.id) && this.datasetRunId.equals(other.datasetRunId) && this.datasetRunName.equals(other.datasetRunName) && this.datasetItemId.equals(other.datasetItemId) && this.traceId.equals(other.traceId) && this.observationId.equals(other.observationId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.datasetRunId, this.datasetRunName, this.datasetItemId, this.traceId, this.observationId, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    DatasetRunIdStage,
    DatasetRunNameStage,
    DatasetItemIdStage,
    TraceIdStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String datasetRunId;
        private String datasetRunName;
        private String datasetItemId;
        private String traceId;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<String> observationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DatasetRunItem other) {
            this.id(other.getId());
            this.datasetRunId(other.getDatasetRunId());
            this.datasetRunName(other.getDatasetRunName());
            this.datasetItemId(other.getDatasetItemId());
            this.traceId(other.getTraceId());
            this.observationId(other.getObservationId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public DatasetRunIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetRunId")
        public DatasetRunNameStage datasetRunId(@NotNull String datasetRunId) {
            this.datasetRunId = Objects.requireNonNull(datasetRunId, "datasetRunId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetRunName")
        public DatasetItemIdStage datasetRunName(@NotNull String datasetRunName) {
            this.datasetRunName = Objects.requireNonNull(datasetRunName, "datasetRunName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetItemId")
        public TraceIdStage datasetItemId(@NotNull String datasetItemId) {
            this.datasetItemId = Objects.requireNonNull(datasetItemId, "datasetItemId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="traceId")
        public CreatedAtStage traceId(@NotNull String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public DatasetRunItem build() {
            return new DatasetRunItem(this.id, this.datasetRunId, this.datasetRunName, this.datasetItemId, this.traceId, this.observationId, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DatasetRunItem build();

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface TraceIdStage {
        public CreatedAtStage traceId(@NotNull String var1);
    }

    public static interface DatasetItemIdStage {
        public TraceIdStage datasetItemId(@NotNull String var1);
    }

    public static interface DatasetRunNameStage {
        public DatasetItemIdStage datasetRunName(@NotNull String var1);
    }

    public static interface DatasetRunIdStage {
        public DatasetRunNameStage datasetRunId(@NotNull String var1);
    }

    public static interface IdStage {
        public DatasetRunIdStage id(@NotNull String var1);

        public Builder from(DatasetRunItem var1);
    }
}

