/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AnnotationQueue {
    private final String id;
    private final String name;
    private final Optional<String> description;
    private final List<String> scoreConfigIds;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private AnnotationQueue(String id, String name, Optional<String> description, List<String> scoreConfigIds, OffsetDateTime createdAt, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.scoreConfigIds = scoreConfigIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="scoreConfigIds")
    public List<String> getScoreConfigIds() {
        return this.scoreConfigIds;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AnnotationQueue && this.equalTo((AnnotationQueue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AnnotationQueue other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.description.equals(other.description) && this.scoreConfigIds.equals(other.scoreConfigIds) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.scoreConfigIds, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String name;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private List<String> scoreConfigIds = new ArrayList<String>();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AnnotationQueue other) {
            this.id(other.getId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.scoreConfigIds(other.getScoreConfigIds());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllScoreConfigIds(List<String> scoreConfigIds) {
            this.scoreConfigIds.addAll(scoreConfigIds);
            return this;
        }

        @Override
        public _FinalStage addScoreConfigIds(String scoreConfigIds) {
            this.scoreConfigIds.add(scoreConfigIds);
            return this;
        }

        @Override
        @JsonSetter(value="scoreConfigIds", nulls=Nulls.SKIP)
        public _FinalStage scoreConfigIds(List<String> scoreConfigIds) {
            this.scoreConfigIds.clear();
            this.scoreConfigIds.addAll(scoreConfigIds);
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public AnnotationQueue build() {
            return new AnnotationQueue(this.id, this.name, this.description, this.scoreConfigIds, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AnnotationQueue build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage scoreConfigIds(List<String> var1);

        public _FinalStage addScoreConfigIds(String var1);

        public _FinalStage addAllScoreConfigIds(List<String> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(AnnotationQueue var1);
    }
}

