/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ServiceProviderConfig.Builder.class
)
public final class ServiceProviderConfig {
  private final List<String> schemas;

  private final String documentationUri;

  private final ScimFeatureSupport patch;

  private final BulkConfig bulk;

  private final FilterConfig filter;

  private final ScimFeatureSupport changePassword;

  private final ScimFeatureSupport sort;

  private final ScimFeatureSupport etag;

  private final List<AuthenticationScheme> authenticationSchemes;

  private final ResourceMeta meta;

  private final Map<String, Object> additionalProperties;

  private ServiceProviderConfig(List<String> schemas, String documentationUri,
      ScimFeatureSupport patch, BulkConfig bulk, FilterConfig filter,
      ScimFeatureSupport changePassword, ScimFeatureSupport sort, ScimFeatureSupport etag,
      List<AuthenticationScheme> authenticationSchemes, ResourceMeta meta,
      Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.documentationUri = documentationUri;
    this.patch = patch;
    this.bulk = bulk;
    this.filter = filter;
    this.changePassword = changePassword;
    this.sort = sort;
    this.etag = etag;
    this.authenticationSchemes = authenticationSchemes;
    this.meta = meta;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public List<String> getSchemas() {
    return schemas;
  }

  @JsonProperty("documentationUri")
  public String getDocumentationUri() {
    return documentationUri;
  }

  @JsonProperty("patch")
  public ScimFeatureSupport getPatch() {
    return patch;
  }

  @JsonProperty("bulk")
  public BulkConfig getBulk() {
    return bulk;
  }

  @JsonProperty("filter")
  public FilterConfig getFilter() {
    return filter;
  }

  @JsonProperty("changePassword")
  public ScimFeatureSupport getChangePassword() {
    return changePassword;
  }

  @JsonProperty("sort")
  public ScimFeatureSupport getSort() {
    return sort;
  }

  @JsonProperty("etag")
  public ScimFeatureSupport getEtag() {
    return etag;
  }

  @JsonProperty("authenticationSchemes")
  public List<AuthenticationScheme> getAuthenticationSchemes() {
    return authenticationSchemes;
  }

  @JsonProperty("meta")
  public ResourceMeta getMeta() {
    return meta;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ServiceProviderConfig && equalTo((ServiceProviderConfig) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ServiceProviderConfig other) {
    return schemas.equals(other.schemas) && documentationUri.equals(other.documentationUri) && patch.equals(other.patch) && bulk.equals(other.bulk) && filter.equals(other.filter) && changePassword.equals(other.changePassword) && sort.equals(other.sort) && etag.equals(other.etag) && authenticationSchemes.equals(other.authenticationSchemes) && meta.equals(other.meta);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.documentationUri, this.patch, this.bulk, this.filter, this.changePassword, this.sort, this.etag, this.authenticationSchemes, this.meta);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static DocumentationUriStage builder() {
    return new Builder();
  }

  public interface DocumentationUriStage {
    PatchStage documentationUri(@NotNull String documentationUri);

    Builder from(ServiceProviderConfig other);
  }

  public interface PatchStage {
    BulkStage patch(@NotNull ScimFeatureSupport patch);
  }

  public interface BulkStage {
    FilterStage bulk(@NotNull BulkConfig bulk);
  }

  public interface FilterStage {
    ChangePasswordStage filter(@NotNull FilterConfig filter);
  }

  public interface ChangePasswordStage {
    SortStage changePassword(@NotNull ScimFeatureSupport changePassword);
  }

  public interface SortStage {
    EtagStage sort(@NotNull ScimFeatureSupport sort);
  }

  public interface EtagStage {
    MetaStage etag(@NotNull ScimFeatureSupport etag);
  }

  public interface MetaStage {
    _FinalStage meta(@NotNull ResourceMeta meta);
  }

  public interface _FinalStage {
    ServiceProviderConfig build();

    _FinalStage schemas(List<String> schemas);

    _FinalStage addSchemas(String schemas);

    _FinalStage addAllSchemas(List<String> schemas);

    _FinalStage authenticationSchemes(List<AuthenticationScheme> authenticationSchemes);

    _FinalStage addAuthenticationSchemes(AuthenticationScheme authenticationSchemes);

    _FinalStage addAllAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements DocumentationUriStage, PatchStage, BulkStage, FilterStage, ChangePasswordStage, SortStage, EtagStage, MetaStage, _FinalStage {
    private String documentationUri;

    private ScimFeatureSupport patch;

    private BulkConfig bulk;

    private FilterConfig filter;

    private ScimFeatureSupport changePassword;

    private ScimFeatureSupport sort;

    private ScimFeatureSupport etag;

    private ResourceMeta meta;

    private List<AuthenticationScheme> authenticationSchemes = new ArrayList<>();

    private List<String> schemas = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ServiceProviderConfig other) {
      schemas(other.getSchemas());
      documentationUri(other.getDocumentationUri());
      patch(other.getPatch());
      bulk(other.getBulk());
      filter(other.getFilter());
      changePassword(other.getChangePassword());
      sort(other.getSort());
      etag(other.getEtag());
      authenticationSchemes(other.getAuthenticationSchemes());
      meta(other.getMeta());
      return this;
    }

    @java.lang.Override
    @JsonSetter("documentationUri")
    public PatchStage documentationUri(@NotNull String documentationUri) {
      this.documentationUri = Objects.requireNonNull(documentationUri, "documentationUri must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("patch")
    public BulkStage patch(@NotNull ScimFeatureSupport patch) {
      this.patch = Objects.requireNonNull(patch, "patch must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("bulk")
    public FilterStage bulk(@NotNull BulkConfig bulk) {
      this.bulk = Objects.requireNonNull(bulk, "bulk must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("filter")
    public ChangePasswordStage filter(@NotNull FilterConfig filter) {
      this.filter = Objects.requireNonNull(filter, "filter must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("changePassword")
    public SortStage changePassword(@NotNull ScimFeatureSupport changePassword) {
      this.changePassword = Objects.requireNonNull(changePassword, "changePassword must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("sort")
    public EtagStage sort(@NotNull ScimFeatureSupport sort) {
      this.sort = Objects.requireNonNull(sort, "sort must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("etag")
    public MetaStage etag(@NotNull ScimFeatureSupport etag) {
      this.etag = Objects.requireNonNull(etag, "etag must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("meta")
    public _FinalStage meta(@NotNull ResourceMeta meta) {
      this.meta = Objects.requireNonNull(meta, "meta must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllAuthenticationSchemes(
        List<AuthenticationScheme> authenticationSchemes) {
      this.authenticationSchemes.addAll(authenticationSchemes);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAuthenticationSchemes(AuthenticationScheme authenticationSchemes) {
      this.authenticationSchemes.add(authenticationSchemes);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "authenticationSchemes",
        nulls = Nulls.SKIP
    )
    public _FinalStage authenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
      this.authenticationSchemes.clear();
      this.authenticationSchemes.addAll(authenticationSchemes);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemas(List<String> schemas) {
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemas(String schemas) {
      this.schemas.add(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(List<String> schemas) {
      this.schemas.clear();
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public ServiceProviderConfig build() {
      return new ServiceProviderConfig(schemas, documentationUri, patch, bulk, filter, changePassword, sort, etag, authenticationSchemes, meta, additionalProperties);
    }
  }
}
