/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import com.langfuse.client.resources.scim.types.ScimEmail;
import com.langfuse.client.resources.scim.types.ScimName;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateUserRequest.Builder.class
)
public final class CreateUserRequest {
  private final String userName;

  private final ScimName name;

  private final Optional<List<ScimEmail>> emails;

  private final Optional<Boolean> active;

  private final Optional<String> password;

  private final Map<String, Object> additionalProperties;

  private CreateUserRequest(String userName, ScimName name, Optional<List<ScimEmail>> emails,
      Optional<Boolean> active, Optional<String> password,
      Map<String, Object> additionalProperties) {
    this.userName = userName;
    this.name = name;
    this.emails = emails;
    this.active = active;
    this.password = password;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return User's email address (required)
   */
  @JsonProperty("userName")
  public String getUserName() {
    return userName;
  }

  /**
   * @return User's name information
   */
  @JsonProperty("name")
  public ScimName getName() {
    return name;
  }

  /**
   * @return User's email addresses
   */
  @JsonProperty("emails")
  public Optional<List<ScimEmail>> getEmails() {
    return emails;
  }

  /**
   * @return Whether the user is active
   */
  @JsonProperty("active")
  public Optional<Boolean> getActive() {
    return active;
  }

  /**
   * @return Initial password for the user
   */
  @JsonProperty("password")
  public Optional<String> getPassword() {
    return password;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateUserRequest && equalTo((CreateUserRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateUserRequest other) {
    return userName.equals(other.userName) && name.equals(other.name) && emails.equals(other.emails) && active.equals(other.active) && password.equals(other.password);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.userName, this.name, this.emails, this.active, this.password);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static UserNameStage builder() {
    return new Builder();
  }

  public interface UserNameStage {
    NameStage userName(@NotNull String userName);

    Builder from(CreateUserRequest other);
  }

  public interface NameStage {
    _FinalStage name(@NotNull ScimName name);
  }

  public interface _FinalStage {
    CreateUserRequest build();

    _FinalStage emails(Optional<List<ScimEmail>> emails);

    _FinalStage emails(List<ScimEmail> emails);

    _FinalStage active(Optional<Boolean> active);

    _FinalStage active(Boolean active);

    _FinalStage password(Optional<String> password);

    _FinalStage password(String password);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements UserNameStage, NameStage, _FinalStage {
    private String userName;

    private ScimName name;

    private Optional<String> password = Optional.empty();

    private Optional<Boolean> active = Optional.empty();

    private Optional<List<ScimEmail>> emails = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateUserRequest other) {
      userName(other.getUserName());
      name(other.getName());
      emails(other.getEmails());
      active(other.getActive());
      password(other.getPassword());
      return this;
    }

    /**
     * <p>User's email address (required)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("userName")
    public NameStage userName(@NotNull String userName) {
      this.userName = Objects.requireNonNull(userName, "userName must not be null");
      return this;
    }

    /**
     * <p>User's name information</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull ScimName name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Initial password for the user</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage password(String password) {
      this.password = Optional.ofNullable(password);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "password",
        nulls = Nulls.SKIP
    )
    public _FinalStage password(Optional<String> password) {
      this.password = password;
      return this;
    }

    /**
     * <p>Whether the user is active</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage active(Boolean active) {
      this.active = Optional.ofNullable(active);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "active",
        nulls = Nulls.SKIP
    )
    public _FinalStage active(Optional<Boolean> active) {
      this.active = active;
      return this;
    }

    /**
     * <p>User's email addresses</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage emails(List<ScimEmail> emails) {
      this.emails = Optional.ofNullable(emails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "emails",
        nulls = Nulls.SKIP
    )
    public _FinalStage emails(Optional<List<ScimEmail>> emails) {
      this.emails = emails;
      return this;
    }

    @java.lang.Override
    public CreateUserRequest build() {
      return new CreateUserRequest(userName, name, emails, active, password, additionalProperties);
    }
  }
}
