/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.metrics.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = MetricsResponse.Builder.class
)
public final class MetricsResponse {
  private final List<Map<String, Object>> data;

  private final Map<String, Object> additionalProperties;

  private MetricsResponse(List<Map<String, Object>> data,
      Map<String, Object> additionalProperties) {
    this.data = data;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The metrics data. Each item in the list contains the metric values and dimensions requested in the query.
   * Format varies based on the query parameters.
   * Histograms will return an array with [lower, upper, height] tuples.
   */
  @JsonProperty("data")
  public List<Map<String, Object>> getData() {
    return data;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MetricsResponse && equalTo((MetricsResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(MetricsResponse other) {
    return data.equals(other.data);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.data);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<Map<String, Object>> data = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(MetricsResponse other) {
      data(other.getData());
      return this;
    }

    @JsonSetter(
        value = "data",
        nulls = Nulls.SKIP
    )
    public Builder data(List<Map<String, Object>> data) {
      this.data.clear();
      this.data.addAll(data);
      return this;
    }

    public Builder addData(Map<String, Object> data) {
      this.data.add(data);
      return this;
    }

    public Builder addAllData(List<Map<String, Object>> data) {
      this.data.addAll(data);
      return this;
    }

    public MetricsResponse build() {
      return new MetricsResponse(data, additionalProperties);
    }
  }
}
