/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = PatchMediaBody.Builder.class
)
public final class PatchMediaBody {
  private final OffsetDateTime uploadedAt;

  private final int uploadHttpStatus;

  private final Optional<String> uploadHttpError;

  private final Optional<Integer> uploadTimeMs;

  private final Map<String, Object> additionalProperties;

  private PatchMediaBody(OffsetDateTime uploadedAt, int uploadHttpStatus,
      Optional<String> uploadHttpError, Optional<Integer> uploadTimeMs,
      Map<String, Object> additionalProperties) {
    this.uploadedAt = uploadedAt;
    this.uploadHttpStatus = uploadHttpStatus;
    this.uploadHttpError = uploadHttpError;
    this.uploadTimeMs = uploadTimeMs;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The date and time when the media record was uploaded
   */
  @JsonProperty("uploadedAt")
  public OffsetDateTime getUploadedAt() {
    return uploadedAt;
  }

  /**
   * @return The HTTP status code of the upload
   */
  @JsonProperty("uploadHttpStatus")
  public int getUploadHttpStatus() {
    return uploadHttpStatus;
  }

  /**
   * @return The HTTP error message of the upload
   */
  @JsonProperty("uploadHttpError")
  public Optional<String> getUploadHttpError() {
    return uploadHttpError;
  }

  /**
   * @return The time in milliseconds it took to upload the media record
   */
  @JsonProperty("uploadTimeMs")
  public Optional<Integer> getUploadTimeMs() {
    return uploadTimeMs;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof PatchMediaBody && equalTo((PatchMediaBody) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(PatchMediaBody other) {
    return uploadedAt.equals(other.uploadedAt) && uploadHttpStatus == other.uploadHttpStatus && uploadHttpError.equals(other.uploadHttpError) && uploadTimeMs.equals(other.uploadTimeMs);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.uploadedAt, this.uploadHttpStatus, this.uploadHttpError, this.uploadTimeMs);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static UploadedAtStage builder() {
    return new Builder();
  }

  public interface UploadedAtStage {
    UploadHttpStatusStage uploadedAt(@NotNull OffsetDateTime uploadedAt);

    Builder from(PatchMediaBody other);
  }

  public interface UploadHttpStatusStage {
    _FinalStage uploadHttpStatus(int uploadHttpStatus);
  }

  public interface _FinalStage {
    PatchMediaBody build();

    _FinalStage uploadHttpError(Optional<String> uploadHttpError);

    _FinalStage uploadHttpError(String uploadHttpError);

    _FinalStage uploadTimeMs(Optional<Integer> uploadTimeMs);

    _FinalStage uploadTimeMs(Integer uploadTimeMs);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements UploadedAtStage, UploadHttpStatusStage, _FinalStage {
    private OffsetDateTime uploadedAt;

    private int uploadHttpStatus;

    private Optional<Integer> uploadTimeMs = Optional.empty();

    private Optional<String> uploadHttpError = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(PatchMediaBody other) {
      uploadedAt(other.getUploadedAt());
      uploadHttpStatus(other.getUploadHttpStatus());
      uploadHttpError(other.getUploadHttpError());
      uploadTimeMs(other.getUploadTimeMs());
      return this;
    }

    /**
     * <p>The date and time when the media record was uploaded</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("uploadedAt")
    public UploadHttpStatusStage uploadedAt(@NotNull OffsetDateTime uploadedAt) {
      this.uploadedAt = Objects.requireNonNull(uploadedAt, "uploadedAt must not be null");
      return this;
    }

    /**
     * <p>The HTTP status code of the upload</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("uploadHttpStatus")
    public _FinalStage uploadHttpStatus(int uploadHttpStatus) {
      this.uploadHttpStatus = uploadHttpStatus;
      return this;
    }

    /**
     * <p>The time in milliseconds it took to upload the media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage uploadTimeMs(Integer uploadTimeMs) {
      this.uploadTimeMs = Optional.ofNullable(uploadTimeMs);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "uploadTimeMs",
        nulls = Nulls.SKIP
    )
    public _FinalStage uploadTimeMs(Optional<Integer> uploadTimeMs) {
      this.uploadTimeMs = uploadTimeMs;
      return this;
    }

    /**
     * <p>The HTTP error message of the upload</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage uploadHttpError(String uploadHttpError) {
      this.uploadHttpError = Optional.ofNullable(uploadHttpError);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "uploadHttpError",
        nulls = Nulls.SKIP
    )
    public _FinalStage uploadHttpError(Optional<String> uploadHttpError) {
      this.uploadHttpError = uploadHttpError;
      return this;
    }

    @java.lang.Override
    public PatchMediaBody build() {
      return new PatchMediaBody(uploadedAt, uploadHttpStatus, uploadHttpError, uploadTimeMs, additionalProperties);
    }
  }
}
