/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = IngestionError.Builder.class
)
public final class IngestionError {
  private final String id;

  private final int status;

  private final Optional<String> message;

  private final Optional<Object> error;

  private final Map<String, Object> additionalProperties;

  private IngestionError(String id, int status, Optional<String> message, Optional<Object> error,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.status = status;
    this.message = message;
    this.error = error;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("status")
  public int getStatus() {
    return status;
  }

  @JsonProperty("message")
  public Optional<String> getMessage() {
    return message;
  }

  @JsonProperty("error")
  public Optional<Object> getError() {
    return error;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof IngestionError && equalTo((IngestionError) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(IngestionError other) {
    return id.equals(other.id) && status == other.status && message.equals(other.message) && error.equals(other.error);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.status, this.message, this.error);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    StatusStage id(@NotNull String id);

    Builder from(IngestionError other);
  }

  public interface StatusStage {
    _FinalStage status(int status);
  }

  public interface _FinalStage {
    IngestionError build();

    _FinalStage message(Optional<String> message);

    _FinalStage message(String message);

    _FinalStage error(Optional<Object> error);

    _FinalStage error(Object error);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, StatusStage, _FinalStage {
    private String id;

    private int status;

    private Optional<Object> error = Optional.empty();

    private Optional<String> message = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(IngestionError other) {
      id(other.getId());
      status(other.getStatus());
      message(other.getMessage());
      error(other.getError());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public StatusStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("status")
    public _FinalStage status(int status) {
      this.status = status;
      return this;
    }

    @java.lang.Override
    public _FinalStage error(Object error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public _FinalStage error(Optional<Object> error) {
      this.error = error;
      return this;
    }

    @java.lang.Override
    public _FinalStage message(String message) {
      this.message = Optional.ofNullable(message);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "message",
        nulls = Nulls.SKIP
    )
    public _FinalStage message(Optional<String> message) {
      this.message = message;
      return this;
    }

    @java.lang.Override
    public IngestionError build() {
      return new IngestionError(id, status, message, error, additionalProperties);
    }
  }
}
