/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Dataset.Builder.class
)
public final class Dataset {
  private final String id;

  private final String name;

  private final Optional<String> description;

  private final Optional<Object> metadata;

  private final String projectId;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final Map<String, Object> additionalProperties;

  private Dataset(String id, String name, Optional<String> description, Optional<Object> metadata,
      String projectId, OffsetDateTime createdAt, OffsetDateTime updatedAt,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.metadata = metadata;
    this.projectId = projectId;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @JsonProperty("metadata")
  public Optional<Object> getMetadata() {
    return metadata;
  }

  @JsonProperty("projectId")
  public String getProjectId() {
    return projectId;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Dataset && equalTo((Dataset) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Dataset other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && metadata.equals(other.metadata) && projectId.equals(other.projectId) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.metadata, this.projectId, this.createdAt, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(Dataset other);
  }

  public interface NameStage {
    ProjectIdStage name(@NotNull String name);
  }

  public interface ProjectIdStage {
    CreatedAtStage projectId(@NotNull String projectId);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface _FinalStage {
    Dataset build();

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, ProjectIdStage, CreatedAtStage, UpdatedAtStage, _FinalStage {
    private String id;

    private String name;

    private String projectId;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> description = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(Dataset other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      metadata(other.getMetadata());
      projectId(other.getProjectId());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public ProjectIdStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("projectId")
    public CreatedAtStage projectId(@NotNull String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("updatedAt")
    public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    @java.lang.Override
    public Dataset build() {
      return new Dataset(id, name, description, metadata, projectId, createdAt, updatedAt, additionalProperties);
    }
  }
}
