/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = AnnotationQueue.Builder.class
)
public final class AnnotationQueue {
  private final String id;

  private final String name;

  private final Optional<String> description;

  private final List<String> scoreConfigIds;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final Map<String, Object> additionalProperties;

  private AnnotationQueue(String id, String name, Optional<String> description,
      List<String> scoreConfigIds, OffsetDateTime createdAt, OffsetDateTime updatedAt,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.scoreConfigIds = scoreConfigIds;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @JsonProperty("scoreConfigIds")
  public List<String> getScoreConfigIds() {
    return scoreConfigIds;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof AnnotationQueue && equalTo((AnnotationQueue) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(AnnotationQueue other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && scoreConfigIds.equals(other.scoreConfigIds) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.scoreConfigIds, this.createdAt, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(AnnotationQueue other);
  }

  public interface NameStage {
    CreatedAtStage name(@NotNull String name);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface _FinalStage {
    AnnotationQueue build();

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);

    _FinalStage scoreConfigIds(List<String> scoreConfigIds);

    _FinalStage addScoreConfigIds(String scoreConfigIds);

    _FinalStage addAllScoreConfigIds(List<String> scoreConfigIds);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, CreatedAtStage, UpdatedAtStage, _FinalStage {
    private String id;

    private String name;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private List<String> scoreConfigIds = new ArrayList<>();

    private Optional<String> description = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(AnnotationQueue other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      scoreConfigIds(other.getScoreConfigIds());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public CreatedAtStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("updatedAt")
    public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllScoreConfigIds(List<String> scoreConfigIds) {
      this.scoreConfigIds.addAll(scoreConfigIds);
      return this;
    }

    @java.lang.Override
    public _FinalStage addScoreConfigIds(String scoreConfigIds) {
      this.scoreConfigIds.add(scoreConfigIds);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "scoreConfigIds",
        nulls = Nulls.SKIP
    )
    public _FinalStage scoreConfigIds(List<String> scoreConfigIds) {
      this.scoreConfigIds.clear();
      this.scoreConfigIds.addAll(scoreConfigIds);
      return this;
    }

    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    @java.lang.Override
    public AnnotationQueue build() {
      return new AnnotationQueue(id, name, description, scoreConfigIds, createdAt, updatedAt, additionalProperties);
    }
  }
}
