/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.annotationqueues.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import com.langfuse.client.resources.annotationqueues.types.AnnotationQueueStatus;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetAnnotationQueueItemsRequest.Builder.class
)
public final class GetAnnotationQueueItemsRequest {
  private final Optional<AnnotationQueueStatus> status;

  private final Optional<Integer> page;

  private final Optional<Integer> limit;

  private final Map<String, Object> additionalProperties;

  private GetAnnotationQueueItemsRequest(Optional<AnnotationQueueStatus> status,
      Optional<Integer> page, Optional<Integer> limit, Map<String, Object> additionalProperties) {
    this.status = status;
    this.page = page;
    this.limit = limit;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Filter by status
   */
  @JsonProperty("status")
  public Optional<AnnotationQueueStatus> getStatus() {
    return status;
  }

  /**
   * @return page number, starts at 1
   */
  @JsonProperty("page")
  public Optional<Integer> getPage() {
    return page;
  }

  /**
   * @return limit of items per page
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetAnnotationQueueItemsRequest && equalTo((GetAnnotationQueueItemsRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetAnnotationQueueItemsRequest other) {
    return status.equals(other.status) && page.equals(other.page) && limit.equals(other.limit);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.status, this.page, this.limit);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<AnnotationQueueStatus> status = Optional.empty();

    private Optional<Integer> page = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(GetAnnotationQueueItemsRequest other) {
      status(other.getStatus());
      page(other.getPage());
      limit(other.getLimit());
      return this;
    }

    @JsonSetter(
        value = "status",
        nulls = Nulls.SKIP
    )
    public Builder status(Optional<AnnotationQueueStatus> status) {
      this.status = status;
      return this;
    }

    public Builder status(AnnotationQueueStatus status) {
      this.status = Optional.ofNullable(status);
      return this;
    }

    @JsonSetter(
        value = "page",
        nulls = Nulls.SKIP
    )
    public Builder page(Optional<Integer> page) {
      this.page = page;
      return this;
    }

    public Builder page(Integer page) {
      this.page = Optional.ofNullable(page);
      return this;
    }

    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    public GetAnnotationQueueItemsRequest build() {
      return new GetAnnotationQueueItemsRequest(status, page, limit, additionalProperties);
    }
  }
}
