/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.io.FileNotFoundException;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import kong.unirest.core.ProgressMonitor;
import kong.unirest.core.UnirestException;
import kong.unirest.core.java.BoundaryAppender;
import kong.unirest.core.java.MultipartSubscription;
import kong.unirest.core.java.Part;
import kong.unirest.core.java.PartPublisher;

final class MultipartBodyPublisher
implements HttpRequest.BodyPublisher {
    private static final long UNKNOWN_LENGTH = -1L;
    private static final long UNINITIALIZED_LENGTH = -2L;
    private final List<Part> parts;
    private final ProgressMonitor monitor;
    private final String boundary;
    private long contentLength;

    private MultipartBodyPublisher(List<Part> parts, ProgressMonitor monitor, String boundary) {
        this.parts = parts;
        this.monitor = monitor;
        this.boundary = boundary;
        this.contentLength = -2L;
    }

    String boundary() {
        return this.boundary;
    }

    List<Part> parts() {
        return this.parts;
    }

    @Override
    public long contentLength() {
        long len = this.contentLength;
        if (len == -2L) {
            this.contentLength = len = this.computeLength();
        }
        return len;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber);
        new MultipartSubscription(this.boundary, this.parts, this.monitor, subscriber).signal(true);
    }

    private long computeLength() {
        long lengthOfParts = 0L;
        String boundary = this.boundary();
        StringBuilder headings = new StringBuilder();
        int sz = this.parts.size();
        for (int i = 0; i < sz; ++i) {
            Part part = this.parts.get(i);
            long partLength = part.bodyPublisher().contentLength();
            if (partLength < 0L) {
                return -1L;
            }
            lengthOfParts += partLength;
            BoundaryAppender.get(i, sz).append(headings, boundary);
            MultipartBodyPublisher.appendPartHeaders(headings, part);
            headings.append("\r\n");
        }
        BoundaryAppender.LAST.append(headings, boundary);
        return lengthOfParts + (long)StandardCharsets.UTF_8.encode(CharBuffer.wrap(headings)).remaining();
    }

    static void appendPartHeaders(StringBuilder target, Part part) {
        part.headers().all().forEach(h -> MultipartBodyPublisher.appendHeader(target, h.getName(), h.getValue()));
    }

    private static void appendHeader(StringBuilder target, String name, String value) {
        target.append(name).append(": ").append(value).append("\r\n");
    }

    static Builder newBuilder(String boundary) {
        return new Builder(boundary);
    }

    static final class Builder {
        private final List<Part> parts;
        private final String boundary;

        Builder(String boundary) {
            this.boundary = boundary;
            this.parts = new ArrayList<Part>();
        }

        Builder formPart(String name, HttpRequest.BodyPublisher bodyPublisher, String contentType) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(bodyPublisher, "body");
            this.parts.add(new Part(name, null, bodyPublisher, contentType));
            return this;
        }

        Builder formPart(String name, String filename, HttpRequest.BodyPublisher body, String contentType) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(filename, "filename");
            Objects.requireNonNull(body, "body");
            this.parts.add(new Part(name, filename, body, contentType));
            return this;
        }

        Builder textPart(String name, Object value, String contentType) {
            return this.textPart(name, value, StandardCharsets.UTF_8, contentType);
        }

        Builder textPart(String name, Object value, Charset charset, String contentType) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(value, "value");
            Objects.requireNonNull(charset, "charset");
            return this.formPart(name, HttpRequest.BodyPublishers.ofString(value.toString(), charset), contentType);
        }

        Builder filePart(String name, Path file, String mediaType) throws FileNotFoundException {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(file, "file");
            Objects.requireNonNull(mediaType, "mediaType");
            Path filenameComponent = file.getFileName();
            String filename = filenameComponent != null ? filenameComponent.toString() : "";
            PartPublisher publisher = new PartPublisher(HttpRequest.BodyPublishers.ofFile(file), mediaType);
            return this.formPart(name, filename, publisher, mediaType);
        }

        MultipartBodyPublisher build(ProgressMonitor monitor) {
            List<Part> addedParts = List.copyOf(this.parts);
            if (addedParts.isEmpty()) {
                throw new UnirestException("at least one part should be added");
            }
            return new MultipartBodyPublisher(addedParts, monitor, this.boundary);
        }
    }
}

