/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.LongArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVLongQHash;
import com.koloboke.collect.impl.hash.UpdatableQHash;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableSeparateKVLongQHashSO
extends UpdatableQHash
implements SeparateKVLongQHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] set;

    void copy(SeparateKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (long[])hash.keys().clone();
    }

    void move(SeparateKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private long findNewFreeOrRemoved() {
        long newFree;
        long free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextLong()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    long changeFree() {
        int mc = this.modCount();
        long newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        LongArrays.replaceAll((long[])this.set, (long)this.freeValue, (long)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new long[capacity];
        if (this.freeValue != 0L) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

