/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashOverflowException;
import com.koloboke.collect.impl.ByteArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHash;
import com.koloboke.collect.impl.hash.SeparateKVByteLHash;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class MutableSeparateKVByteLHashSO
extends MutableLHash
implements SeparateKVByteLHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    byte[] set;

    void copy(SeparateKVByteLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (byte[])hash.keys().clone();
    }

    void move(SeparateKVByteLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public byte removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            byte cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private byte findNewFreeOrRemoved() {
        byte newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 255) {
                throw new HashOverflowException();
            }
            byte free = this.freeValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 192) {
                int nf = ((Random)random).nextInt(256) * 97;
                for (int i = 0; i < 256; ++i) {
                    newFree = (byte)(nf += 97);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (byte)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    byte changeFree() {
        int mc = this.modCount();
        byte newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ByteArrays.replaceAll((byte[])this.set, (byte)this.freeValue, (byte)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new byte[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

