/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongObjMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalLongObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVLongObjMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVLongQHashGO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVLongObjQHash;
import com.koloboke.collect.map.LongObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashLongSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.LongObjConsumer;
import com.koloboke.function.LongObjFunction;
import com.koloboke.function.LongObjPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVLongObjMapGO<V>
extends MutableQHashSeparateKVLongObjMapSO<V> {
    @Override
    final void copy(SeparateKVLongObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(long key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(long key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongObjCursor<V> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongObjMapOps.containsAllEntries((InternalLongObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                hashCode += (int)(key ^ key >>> 32) ^ this.nullableValueHashCode(vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += (int)(key ^ key >>> 32) ^ this.nullableValueHashCode(vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        Object[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public V put(Long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V put(long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V putIfAbsent(Long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public V putIfAbsent(long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public void justPut(long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public V compute(Long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        V newValue;
        int index;
        Object[] vals;
        long removed;
        long k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                V newValue2;
                block29: {
                    if (cur != free) {
                        V newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(k, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    public V compute(long key, LongObjFunction<? super V, ? extends V> remappingFunction) {
        Object newValue;
        int index;
        Object[] vals;
        long removed;
        block28: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                Object newValue2;
                block29: {
                    if (cur != free) {
                        Object newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return (V)newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return (V)newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    public V computeIfAbsent(Long key, Function<? super Long, ? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        long k;
        block29: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                V value;
                block30: {
                    if (cur != free) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(k)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(k)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        V value = mappingFunction.apply(k);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        block29: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                V value;
                block30: {
                    if (cur != free) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(key)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        V value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfPresent(Long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(k, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(long key, LongObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    public V merge(Long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        long removed;
        block28: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    public V merge(long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        long removed;
        block28: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends V> m) {
        CommonLongObjMapOps.putAll((InternalLongObjMapOps)this, m);
    }

    public V replace(Long key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public V replace(long key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public boolean replace(Long key, V oldValue, V newValue) {
        return this.replace((long)key, oldValue, newValue);
    }

    public boolean replace(long key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Long, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.values[index] = null;
        this.postRemoveHook();
    }

    public V remove(Object key) {
        long removed;
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.values[index] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public V remove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, value);
    }

    public boolean remove(long key, Object value) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            Object[] vals;
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.nullableValueEquals((vals = this.values)[index], value)) {
                this.incrementModCount();
                keys[index] = removed;
                vals[index] = null;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongObjPredicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !filter.test((Long)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !filter.test((Long)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public LongIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyIterator(mc);
        }
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public LongCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyCursor(mc);
        }
        return new NoRemovedKeyCursor(mc);
    }

    class SomeRemovedMapCursor
    implements LongObjCursor<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements LongObjCursor<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ObjCursor<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ObjIterator<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, V>> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, V> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, V>> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, V> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, V>> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, V> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, V>> {
        final long[] keys;
        final V[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            V[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, V> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return MutableQHashSeparateKVLongObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return MutableQHashSeparateKVLongObjMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVLongObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.remove(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    if (keys[i] == free) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return MutableQHashSeparateKVLongObjMapGO.this.removeValue(o);
        }

        public void clear() {
            MutableQHashSeparateKVLongObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongObjEntry {
        private long key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongObjEntry {
        final int modCount;
        private final int index;
        final long key;
        private V value;

        MutableEntry(int modCount, int index, long key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public V setValue(V newValue) {
            if (this.modCount != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            MutableQHashSeparateKVLongObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class LongObjEntry
    extends AbstractEntry<Long, V> {
        LongObjEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && MutableQHashSeparateKVLongObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ MutableQHashSeparateKVLongObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, V>>
    implements HashObjSet<Map.Entry<Long, V>>,
    InternalObjCollectionOps<Map.Entry<Long, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), MutableQHashSeparateKVLongObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVLongObjMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVLongObjMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVLongObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVLongObjMapGO.this.containsEntry((Long)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, V>> iterator() {
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, V>> cursor() {
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVLongObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                Object value = e.getValue();
                return MutableQHashSeparateKVLongObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongObjMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongObjMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongObjMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVLongObjMapGO.this.values;
            if (MutableQHashSeparateKVLongObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVLongObjMapGO.this.doClear();
        }
    }

    class SomeRemovedKeyCursor
    extends MutableSeparateKVLongQHashGO.SomeRemovedCursor {
        final V[] vals;

        private SomeRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVLongObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
        }

        @Override
        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedKeyIterator
    extends MutableSeparateKVLongQHashGO.SomeRemovedIterator {
        final V[] vals;

        private SomeRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVLongObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVLongQHashGO.NoRemovedCursor {
        final V[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVLongObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
        }

        @Override
        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVLongQHashGO.NoRemovedIterator {
        final V[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVLongObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVLongObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVLongObjMapGO.this.postRemoveHook();
        }
    }
}

