/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongCharMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalLongCharMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVLongCharMapSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVLongCharQHash;
import com.koloboke.collect.map.LongCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.LongCharConsumer;
import com.koloboke.function.LongCharPredicate;
import com.koloboke.function.LongCharToCharFunction;
import com.koloboke.function.LongToCharFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVLongCharMapGO
extends MutableQHashSeparateKVLongCharMapSO {
    @Override
    final void copy(SeparateKVLongCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(long key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Character get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(long key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Long)key, Character.valueOf(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Long)key, Character.valueOf(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongCharCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongCharMapOps.containsAllEntries((InternalLongCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                hashCode += (int)(key ^ key >>> 32) ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += (int)(key ^ key >>> 32) ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        char[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character put(Long key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    public char put(long key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Character putIfAbsent(Long key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    public char putIfAbsent(long key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(long key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Character compute(Long key, BiFunction<? super Long, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        long removed;
        long k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                Character newValue2;
                block29: {
                    if (cur != free) {
                        Character newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Long)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3.charValue();
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2.charValue();
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public char compute(long key, LongCharToCharFunction remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = remappingFunction.applyAsChar(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
        return newValue;
    }

    public Character computeIfAbsent(Long key, Function<? super Long, ? extends Character> mappingFunction) {
        Character value;
        long k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur == k) {
                return Character.valueOf(vals[index]);
            }
            if (cur != free) {
                Character value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return Character.valueOf(vals[bIndex]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return Character.valueOf(vals[fIndex]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return Character.valueOf(vals[bIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return Character.valueOf(vals[fIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Long)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2.charValue();
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value.charValue();
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(long key, LongToCharFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur == key) {
                return vals[index];
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return vals[bIndex];
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return vals[fIndex];
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return vals[bIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return vals[fIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                char value = mappingFunction.applyAsChar(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Character computeIfPresent(Long key, BiFunction<? super Long, ? super Character, ? extends Character> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply((Long)k, Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public char computeIfPresent(long key, LongCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    public Character merge(Long key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        long removed;
        block27: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value.charValue();
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value.charValue();
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public char merge(long key, char value, CharBinaryOperator remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(long key, char value) {
        char newValue;
        int index;
        char[] vals;
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(this.defaultValue() + value);
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(long key, char addition, char initialValue) {
        char newValue;
        int index;
        char[] vals;
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(initialValue + addition);
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends Character> m) {
        CommonLongCharMapOps.putAll((InternalLongCharMapOps)this, m);
    }

    public Character replace(Long key, Character value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    public char replace(long key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Long key, Character oldValue, Character newValue) {
        return this.replace((long)key, oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(long key, char oldValue, char newValue) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Long, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply((Long)key, Character.valueOf(vals[i])).charValue();
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply((Long)key, Character.valueOf(vals[i])).charValue();
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                vals[i] = function.applyAsChar(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.applyAsChar(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Character remove(Object key) {
        long removed;
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            char val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return Character.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public char remove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, ((Character)value).charValue());
    }

    public boolean remove(long key, char value) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == value) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements LongCharCursor {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements LongCharCursor {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements CharCursor {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements CharIterator {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Character>> {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Character> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Character>> {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Character>> {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Character> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Character>> {
        final long[] keys;
        final char[] vals;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            long free = this.free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            char[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVLongCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVLongCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableQHashSeparateKVLongCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(Character.valueOf(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(Character.valueOf(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeChar(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeChar(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = Character.valueOf(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Character.valueOf(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = Character.valueOf(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Character.valueOf(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableQHashSeparateKVLongCharMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashSeparateKVLongCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongCharEntry {
        private long key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongCharEntry {
        final int modCount;
        private final int index;
        final long key;
        private char value;

        MutableEntry(int modCount, int index, long key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            MutableQHashSeparateKVLongCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class LongCharEntry
    extends AbstractEntry<Long, Character> {
        LongCharEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Character>>
    implements HashObjSet<Map.Entry<Long, Character>>,
    InternalObjCollectionOps<Map.Entry<Long, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVLongCharMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVLongCharMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVLongCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVLongCharMapGO.this.containsEntry((Long)e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || predicate.test((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, Character>> iterator() {
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Character>> cursor() {
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVLongCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVLongCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return MutableQHashSeparateKVLongCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !filter.test((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry<Long, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVLongCharMapGO.this.modCount();
            long free = MutableQHashSeparateKVLongCharMapGO.this.freeValue;
            long removed = MutableQHashSeparateKVLongCharMapGO.this.removedValue;
            long[] keys = MutableQHashSeparateKVLongCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVLongCharMapGO.this.values;
            if (MutableQHashSeparateKVLongCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVLongCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVLongCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVLongCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVLongCharMapGO.this.doClear();
        }
    }
}

