/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalLongDoubleMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVLongDoubleMapSO;
import com.koloboke.collect.impl.hash.ParallelKVLongDoubleQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.LongDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.LongDoubleConsumer;
import com.koloboke.function.LongDoublePredicate;
import com.koloboke.function.LongDoubleToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.LongToDoubleFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashParallelKVLongDoubleMapGO
extends MutableQHashParallelKVLongDoubleMapSO {
    final void copy(ParallelKVLongDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVLongDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return null;
    }

    public double get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public double getOrDefault(long key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Long)key, (Double)Double.longBitsToDouble(tab[i + 1]));
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Long)key, (Double)Double.longBitsToDouble(tab[i + 1]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || predicate.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongDoubleCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongDoubleMapOps.containsAllEntries((InternalLongDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || m.containsEntry(key, tab[i + 1])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || m.containsEntry(key, tab[i + 1])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                m.justPut(key, tab[i + 1]);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                m.justPut(key, tab[i + 1]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                long val = tab[i + 1];
                hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                long val = tab[i + 1];
                hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
                if (newTab[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newTab[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newTab[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                newTab[index] = key;
                newTab[index + 1] = tab[i + 1];
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
                if (newTab[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newTab[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newTab[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                newTab[index] = key;
                newTab[index + 1] = tab[i + 1];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double put(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public double put(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        double prevValue = Double.longBitsToDouble(tab[index + 1]);
        tab[index + 1] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public Double putIfAbsent(Long key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    public double putIfAbsent(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.table[index + 1]);
    }

    public void justPut(long key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.table[index + 1] = Double.doubleToLongBits(value);
    }

    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    public Double compute(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] tab;
        long removed;
        long k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                Double newValue2;
                block29: {
                    if (cur != free) {
                        Double newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        if ((newValue3 = remappingFunction.apply((Long)k, null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = k;
                            tab[firstRemoved + 1] = Double.doubleToLongBits(newValue3);
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = Double.doubleToLongBits(newValue2);
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]))) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        tab[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public double compute(long key, LongDoubleToDoubleFunction remappingFunction) {
        int index;
        long[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public Double computeIfAbsent(Long key, Function<? super Long, ? extends Double> mappingFunction) {
        Double value;
        long k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)k) % capacity;
            long cur = tab[index];
            if (cur == k) {
                return Double.longBitsToDouble(tab[index + 1]);
            }
            if (cur != free) {
                Double value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                return Double.longBitsToDouble(tab[bIndex + 1]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                return Double.longBitsToDouble(tab[fIndex + 1]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 4;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == k) {
                        return Double.longBitsToDouble(tab[bIndex + 1]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == k) {
                        return Double.longBitsToDouble(tab[fIndex + 1]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 4;
                }
                if ((value2 = mappingFunction.apply((Long)k)) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = k;
                    tab[firstRemoved + 1] = Double.doubleToLongBits(value2);
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = Double.doubleToLongBits(value);
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(long key, LongToDoubleFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur == key) {
                return Double.longBitsToDouble(tab[index + 1]);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                return Double.longBitsToDouble(tab[bIndex + 1]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                return Double.longBitsToDouble(tab[fIndex + 1]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 4;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == key) {
                        return Double.longBitsToDouble(tab[bIndex + 1]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == key) {
                        return Double.longBitsToDouble(tab[fIndex + 1]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 4;
                }
                double value = mappingFunction.applyAsDouble(key);
                this.incrementModCount();
                tab[firstRemoved] = key;
                tab[firstRemoved + 1] = Double.doubleToLongBits(value);
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        double value = mappingFunction.applyAsDouble(key);
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = Double.doubleToLongBits(value);
        this.postFreeSlotInsertHook();
        return value;
    }

    public Double computeIfPresent(Long key, BiFunction<? super Long, ? super Double, ? extends Double> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Double newValue = remappingFunction.apply((Long)k, (Double)Double.longBitsToDouble(tab[index + 1]));
            if (newValue != null) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.incrementModCount();
            this.table[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public double computeIfPresent(long key, LongDoubleToDoubleFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(tab[index + 1]));
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Double merge(Long key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] tab;
        long removed;
        block27: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k;
                        tab[firstRemoved + 1] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(tab[index + 1]), value)) != null) {
            tab[index + 1] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        tab[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public double merge(long key, double value, DoubleBinaryOperator remappingFunction) {
        int index;
        long[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(tab[index + 1]), value);
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(long key, double value) {
        int index;
        long[] tab;
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        double newValue = this.defaultValue() + value;
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = Double.longBitsToDouble(tab[index + 1]) + value;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(long key, double addition, double initialValue) {
        int index;
        long[] tab;
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 2;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = tab[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = tab[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 4;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 2;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = tab[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = tab[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 4;
                        }
                        double newValue = initialValue + addition;
                        this.incrementModCount();
                        tab[firstRemoved] = key;
                        tab[firstRemoved + 1] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = Double.longBitsToDouble(tab[index + 1]) + addition;
        tab[index + 1] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends Double> m) {
        CommonLongDoubleMapOps.putAll((InternalLongDoubleMapOps)this, m);
    }

    public Double replace(Long key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    public double replace(long key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            double oldValue = Double.longBitsToDouble(tab[index + 1]);
            tab[index + 1] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Long key, Double oldValue, Double newValue) {
        return this.replace((long)key, (double)oldValue, (double)newValue);
    }

    public boolean replace(long key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == Double.doubleToLongBits(oldValue)) {
                tab[index + 1] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Long, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                tab[i + 1] = Double.doubleToLongBits(function.apply((Long)key, (Double)Double.longBitsToDouble(tab[i + 1])));
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                tab[i + 1] = Double.doubleToLongBits(function.apply((Long)key, (Double)Double.longBitsToDouble(tab[i + 1])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                tab[i + 1] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(tab[i + 1])));
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                tab[i + 1] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(tab[i + 1])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Double remove(Object key) {
        long removed;
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 4;
                }
            }
            double val = Double.longBitsToDouble(tab[index + 1]);
            this.incrementModCount();
            tab[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 4;
                }
            }
            this.incrementModCount();
            tab[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public double remove(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 4;
                }
            }
            double val = Double.longBitsToDouble(tab[index + 1]);
            this.incrementModCount();
            tab[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Double)value);
    }

    public boolean remove(long key, double value) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = tab[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = tab[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 4;
                }
            }
            if (tab[index + 1] == Double.doubleToLongBits(value)) {
                this.incrementModCount();
                tab[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongDoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || !filter.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || !filter.test(key, Double.longBitsToDouble(tab[i + 1]))) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements LongDoubleCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements LongDoubleCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements DoubleCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements DoubleIterator {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free || key == removed) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long removed = this.removed;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free || key == removed) continue;
                        this.next = Double.longBitsToDouble(tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == free) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == free) continue;
                        this.next = Double.longBitsToDouble(tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Double> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long removed = this.removed;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (index != this.index || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Double> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Double>> {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            long free = this.free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Double> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashParallelKVLongDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVLongDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashParallelKVLongDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableQHashParallelKVLongDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return MutableQHashParallelKVLongDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    action.accept(Double.longBitsToDouble(tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    action.accept(Double.longBitsToDouble(tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || c.contains(tab[i + 1])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains(tab[i + 1])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    changed |= c.add(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    changed |= s.removeDouble(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeDouble(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            if (!MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            if (!MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free) continue;
                    sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableQHashParallelKVLongDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return MutableQHashParallelKVLongDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableQHashParallelKVLongDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || !filter.test((Double)Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !filter.test((Double)Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || !filter.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !filter.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || !c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    if (tab[i] == free || c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains(tab[i + 1])) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongDoubleEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongDoubleEntry {
        final int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableQHashParallelKVLongDoubleMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class LongDoubleEntry
    extends AbstractEntry<Long, Double> {
        LongDoubleEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Double>>
    implements HashObjSet<Map.Entry<Long, Double>>,
    InternalObjCollectionOps<Map.Entry<Long, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVLongDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashParallelKVLongDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashParallelKVLongDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVLongDoubleMapGO.this.containsEntry((long)((Long)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || predicate.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || predicate.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, Double>> iterator() {
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            if (!MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Double>> cursor() {
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            if (!MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashParallelKVLongDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(tab[i + 1]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(tab[i + 1]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVLongDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                double value = (Double)e.getValue();
                return MutableQHashParallelKVLongDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || !filter.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !filter.test((Map.Entry<Long, Double>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || !c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVLongDoubleMapGO.this.modCount();
            long free = MutableQHashParallelKVLongDoubleMapGO.this.freeValue;
            long removed = MutableQHashParallelKVLongDoubleMapGO.this.removedValue;
            long[] tab = MutableQHashParallelKVLongDoubleMapGO.this.table;
            if (MutableQHashParallelKVLongDoubleMapGO.this.noRemoved()) {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    MutableQHashParallelKVLongDoubleMapGO.this.incrementModCount();
                    ++mc;
                    tab[i] = removed;
                    MutableQHashParallelKVLongDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVLongDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashParallelKVLongDoubleMapGO.this.doClear();
        }
    }
}

