/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.impl.CommonIntCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalIntCollectionOps;
import com.koloboke.collect.impl.hash.MutableIntQHashSetSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVIntQHash;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.hash.HashIntSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableQHashIntSetGO
extends MutableIntQHashSetSO
implements HashIntSet,
InternalIntCollectionOps {
    @Override
    final void copy(SeparateKVIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonIntCollectionOps.containsAll((IntCollection)this, c);
    }

    @Nonnull
    public IntCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Integer e) {
        return this.add((int)e);
    }

    public boolean add(int key) {
        block24: {
            int removed = this.removedValue;
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Integer> c) {
        return CommonIntCollectionOps.addAll((IntCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeInt((Integer)key);
    }

    @Override
    boolean justRemove(int key) {
        return this.removeInt(key);
    }

    public boolean removeInt(int key) {
        int removed;
        int free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVIntKeyMixing.mix((int)key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            InternalIntCollectionOps c2;
            if (c instanceof InternalIntCollectionOps && (c2 = (InternalIntCollectionOps)c).size() < this.size()) {
                return c2.reverseRemoveAllFrom((IntSet)this);
            }
            return this.removeAll((HashIntSet)this, (IntCollection)c);
        }
        return this.removeAll((HashIntSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

