/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableParallelKVIntLHashSO;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.hash.HashIntSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class MutableParallelKVIntLHashGO
extends MutableParallelKVIntLHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            action.accept((Integer)key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(IntCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(IntCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(IntSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            changed |= s.removeInt(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public IntIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public IntCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public int[] toIntArray() {
        int size = this.size();
        int[] result = new int[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public int[] toArray(int[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new int[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(int var1);

    public boolean removeIf(Predicate<? super Integer> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test((Integer)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(IntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.retainAll(thisC, (IntCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, int delayedRemoved) {
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            int keyToShift;
            int indexToRemove;
            long entry = tab[i];
            if ((int)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements IntCursor {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;

        NoRemovedCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntLHashGO.this.table;
            long[] tab = MutableParallelKVIntLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableParallelKVIntLHashGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVIntLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVIntLHashGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            int free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVIntLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableParallelKVIntLHashGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVIntLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                MutableParallelKVIntLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVIntLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements IntIterator {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        int next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntLHashGO.this.table;
            long[] tab = MutableParallelKVIntLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            int free = this.free = MutableParallelKVIntLHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            if (this.expectedModCount == MutableParallelKVIntLHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Integer)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVIntLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableParallelKVIntLHashGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVIntLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                MutableParallelKVIntLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVIntLHashGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3)));
            }
        }
    }
}

