/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalObjDoubleMapOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVObjKeyMap;
import com.koloboke.collect.impl.hash.SeparateKVObjDoubleLHash;
import com.koloboke.collect.map.hash.HashObjDoubleMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableLHashSeparateKVObjDoubleMapSO<K>
extends MutableLHashSeparateKVObjKeyMap<K>
implements HashObjDoubleMap<K>,
InternalObjDoubleMapOps<K>,
SeparateKVObjDoubleLHash {
    long[] values;

    void copy(SeparateKVObjDoubleLHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVObjDoubleLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(K key, long value) {
        if (key != null) {
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return index;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return index;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.values[index] = value;
            this.postInsertHook();
            return -1;
        }
        return this.insertNullKey(value);
    }

    int insertNullKey(long value) {
        Object[] keys = this.set;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return index;
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

