/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.IntCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableLHashIntSet;
import com.koloboke.collect.impl.hash.ImmutableLHashIntSetGO;
import com.koloboke.collect.impl.hash.IntegerLHashFactory;
import com.koloboke.collect.impl.hash.MutableLHashIntSet;
import com.koloboke.collect.impl.hash.MutableLHashIntSetGO;
import com.koloboke.collect.impl.hash.SeparateKVIntLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashIntSet;
import com.koloboke.collect.impl.hash.UpdatableLHashIntSetGO;
import com.koloboke.collect.set.hash.HashIntSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashIntSetFactorySO
extends IntegerLHashFactory
implements HashIntSetFactory {
    LHashIntSetFactorySO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashIntSetGO uninitializedMutableSet() {
        return new MutableLHashIntSet();
    }

    UpdatableLHashIntSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashIntSet();
    }

    ImmutableLHashIntSetGO uninitializedImmutableSet() {
        return new ImmutableLHashIntSet();
    }

    @Nonnull
    public MutableLHashIntSetGO newMutableSet(int expectedSize) {
        MutableLHashIntSet set = new MutableLHashIntSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashIntSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashIntSet set = new UpdatableLHashIntSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashIntSetGO newUpdatableSet(Iterable<Integer> elements, int expectedSize) {
        if (elements instanceof IntCollection) {
            SeparateKVIntLHash hash;
            if (elements instanceof SeparateKVIntLHash && (hash = (SeparateKVIntLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashIntSet set = new UpdatableLHashIntSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashIntSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashIntSetGO set = this.newUpdatableSet(size);
        for (int e : elements) {
            set.add(e);
        }
        return set;
    }
}

