/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableQHash;
import com.koloboke.collect.impl.hash.ParallelKVShortQHash;
import com.koloboke.collect.impl.hash.QHash;

public abstract class ImmutableParallelKVShortQHashSO
extends ImmutableQHash
implements ParallelKVShortQHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    int[] table;

    void copy(ParallelKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (int[])hash.table().clone();
    }

    void move(ParallelKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }
}

