/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharDoubleMapOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableLHashSeparateKVCharDoubleMapSO;
import com.koloboke.collect.impl.hash.SeparateKVCharDoubleLHash;
import com.koloboke.collect.map.CharDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharDoubleConsumer;
import com.koloboke.function.CharDoublePredicate;
import com.koloboke.function.CharDoubleToDoubleFunction;
import com.koloboke.function.CharToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashSeparateKVCharDoubleMapGO
extends ImmutableLHashSeparateKVCharDoubleMapSO {
    @Override
    final void copy(SeparateKVCharDoubleLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharDoubleLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(char key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(char key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(char key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Double)Double.longBitsToDouble(vals[i]));
        }
    }

    public void forEach(CharDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
    }

    public boolean forEachWhile(CharDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharDoubleCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharDoubleMapOps.containsAllEntries((InternalCharDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Double put(Character key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double put(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public Double putIfAbsent(Character key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double putIfAbsent(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(char key, long value) {
        throw new UnsupportedOperationException();
    }

    public Double compute(Character key, BiFunction<? super Character, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double compute(char key, CharDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfAbsent(Character key, Function<? super Character, ? extends Double> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfAbsent(char key, CharToDoubleFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfPresent(Character key, BiFunction<? super Character, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfPresent(char key, CharDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double merge(Character key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double merge(char key, double value, DoubleBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double addValue(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public double addValue(char key, double addition, double initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Double> m) {
        CommonCharDoubleMapOps.putAll((InternalCharDoubleMapOps)this, m);
    }

    public Double replace(Character key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double replace(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Character key, Double oldValue, Double newValue) {
        return this.replace(key.charValue(), (double)oldValue, (double)newValue);
    }

    public boolean replace(char key, double oldValue, double newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Character, ? super Double, ? extends Double> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharDoubleToDoubleFunction function) {
        throw new UnsupportedOperationException();
    }

    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public double remove(char key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Double)value);
    }

    public boolean remove(char key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharDoubleCursor {
        final char[] keys;
        final long[] vals;
        final char free;
        int index;
        char curKey;
        long curValue;

        NoRemovedMapCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue);
        }

        public void forEachForward(CharDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final char[] keys;
        final long[] vals;
        final char free;
        int index;
        char curKey;
        long curValue;

        NoRemovedValueCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final char[] keys;
        final long[] vals;
        final char free;
        int nextIndex;
        double next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                double prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Double.longBitsToDouble(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Double>> {
        final char[] keys;
        final long[] vals;
        final char free;
        int index;
        char curKey;
        long curValue;

        NoRemovedEntryCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Double> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Double>> {
        final char[] keys;
        final long[] vals;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            long[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public DoubleCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            ImmutableLHashSeparateKVCharDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharDoubleEntry {
        private char key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharDoubleEntry {
        private final char key;
        private final long value;

        ImmutableEntry(char key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class CharDoubleEntry
    extends AbstractEntry<Character, Double> {
        CharDoubleEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Double>>
    implements HashObjSet<Map.Entry<Character, Double>>,
    InternalObjCollectionOps<Map.Entry<Character, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVCharDoubleMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Double>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test((Map.Entry<Character, Double>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Double>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Double>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharDoubleMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharDoubleMapGO.this.set;
            long[] vals = ImmutableLHashSeparateKVCharDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                double value = (Double)e.getValue();
                return ImmutableLHashSeparateKVCharDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

