/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Closeables
implements Closeable {
    private List<WeakReference<Closeable>> list;

    public Closeables() {
    }

    public Closeables(Closeable ... closeable) {
        for (Closeable cl : closeable) {
            this.list.add(new HardReference(cl));
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    public void close(IOException superException) throws IOException {
        IOException exc = superException;
        if (this.list != null) {
            for (WeakReference<Closeable> ref : this.list) {
                Closeable cl = (Closeable)ref.get();
                if (cl == null) continue;
                try {
                    cl.close();
                }
                catch (IOException e) {
                    if (exc == null) {
                        exc = e;
                        continue;
                    }
                    exc.addSuppressed(e);
                }
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    public synchronized boolean add(WeakReference<Closeable> closeable) {
        Closeable cl = (Closeable)closeable.get();
        if (cl == null) {
            return false;
        }
        if (this.list == null) {
            this.list = new ArrayList<WeakReference<Closeable>>();
        } else {
            for (WeakReference<Closeable> ref : this.list) {
                if (ref.get() != cl) continue;
                return false;
            }
        }
        this.list.add(closeable);
        return true;
    }

    public synchronized boolean add(Closeable closeable) {
        return this.add(new HardReference<Closeable>(closeable));
    }

    public synchronized boolean remove(Closeable closeable) {
        if (this.list == null || closeable == null) {
            return false;
        }
        Iterator<WeakReference<Closeable>> it = this.list.iterator();
        while (it.hasNext()) {
            if (it.next().get() != closeable) continue;
            it.remove();
            return true;
        }
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class HardReference<V>
    extends WeakReference<V> {
        private final V strongRef;

        private HardReference(V referent) {
            super(null);
            this.strongRef = referent;
        }

        @Override
        public V get() {
            return this.strongRef;
        }
    }
}

